﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using Microsoft.AspNetCore.Mvc;
using NPOI.SS.Formula.Functions;
using Siger.ApiCommon.Filters;
using Siger.ApiCommon.Result;
using Siger.ApiCommon.Utilities;
using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Repositories.Interface;
using Siger.Middlelayer.AccRepository.Request;
using Siger.Middlelayer.AccRepository.Response;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.AppSettings;
using Siger.Middlelayer.Common.Extensions;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Common.ModuleEnum;
using Siger.Middlelayer.Log;
using Siger.Middlelayer.Repository;
using Siger.Middlelayer.Repository.Repositories.Interface;
using Siger.Middlelayer.Utility.Helpers;
using Siger.Middlelayer.Utility.ImportEntities;

namespace Siger.ApiACC.Controllers
{
    public class AppAssembController : BaseController
    {
        private readonly ISigerTrSnTraceRepository _trSnTrace;
        private readonly ISigerTrSnTraceDetailsRepository _sigerTrSnTraceDetails;
        private readonly IUnitOfWork _unitOfWork;
        private readonly ISnListRepository _snList;
        private readonly ISigerProjectProductRepository _sigerProjectProduct;
        private readonly IProductPlanDetails _productPlanDetails;
        private readonly IProductPlanRepository _planRepository;
        private readonly IInspectStandardRepository _inspectStandard;
        private readonly IInspectStandardOptionRepository _inspectStandardOptionRepository;
        private readonly ITypeCountSettingRepository _countSettingRepository;
        private readonly ISigetTrAssemblyDetails _sigetTrAssemblyDetailsRepository;
        private readonly ISigerTrAssistMaterialsRepository _sigerTrAssistMaterialsRepository;
        private readonly ISigerProjectOrderTypeRepository _sigerProjectOrderTypeRepository;
        private readonly ISigerProjectLevelSectionRepository _sigerProjectLevelSectionRepository;
        private readonly ISigerUserRepository _sigerUserRepository;

        public AppAssembController(IInspectStandardRepository inspectStandard, ISigetTrAssemblyDetails sigetTrAssemblyDetails, ISigerUserRepository sigerUserRepository
            , IUnitOfWork unitOfWork, IProductPlanRepository planRepository, ISigerProjectProductRepository sigerProjectProduct
            , ISnListRepository snList, ISigerTrSnTraceRepository trSnTrace, ISigerTrSnTraceDetailsRepository sigerTrSnTraceDetails,
            IProductPlanDetails planDetails, ISigerTrAssistMaterialsRepository sigerTrAssistMaterialsRepository, ISigerProjectLevelSectionRepository sigerProjectLevelSectionRepository,
            IInspectStandardOptionRepository inspectStandardOptionRepository, ITypeCountSettingRepository countSettingRepository, ISigerProjectOrderTypeRepository sigerProjectOrderTypeRepository)
        {
            _unitOfWork = unitOfWork;
            _snList = snList;
            _trSnTrace = trSnTrace;
            _sigerTrSnTraceDetails = sigerTrSnTraceDetails;
            _productPlanDetails = planDetails;
            _planRepository = planRepository;
            _sigerProjectProduct = sigerProjectProduct;
            _inspectStandardOptionRepository = inspectStandardOptionRepository;
            _countSettingRepository = countSettingRepository;
            _inspectStandard = inspectStandard;
            _sigetTrAssemblyDetailsRepository = sigetTrAssemblyDetails;
            _sigerTrAssistMaterialsRepository = sigerTrAssistMaterialsRepository;
            _sigerProjectLevelSectionRepository = sigerProjectLevelSectionRepository;
            _sigerUserRepository = sigerUserRepository;
            _sigerProjectOrderTypeRepository = sigerProjectOrderTypeRepository;
        }

        /// <summary>
        /// 根据SN获取产品信息
        /// </summary>
        /// <param name="requestSN"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult CheckSN([FromBody] RequestSNList requestSN)
        {
            var pid = ProjectId;
            var snlist = _snList.Get(f => f.projectId == pid && f.SN == requestSN.SN);
            if (snlist == null)
            {
                throw new BadRequestException(AccEnum.Busi_SN_Null);
            }
            var ordertype = _sigerProjectOrderTypeRepository.Get(f => f.projectId == pid && f.code == snlist.WoType);
            if (ordertype == null)
            {
                throw new BadRequestException(AccEnum.OrderTypeMiss);
            }
            var plan = _planRepository.Get(f => f.projectId == pid && f.code == snlist.WO && f.workordertype == ordertype.id);
            if (plan == null)
            {
                throw new BadRequestException(CncEnum.PlanNotFound);
            }
            var count = _trSnTrace.GetList(q => q.WO == snlist.WO && q.projectId == pid && q.status == (int)RowState.Valid && q.Station == requestSN.SectionId).Count();
            var result = new ResponseProductCode();
            result.SN = snlist.SN;
            result.PN = plan.product_name;
            result.WO = snlist.WO;
            result.drawingcode = plan.draw_number;
            result.number = count;
            result.productId = snlist.ProductId;
            result.productCode = plan.product_code;
            result.sum = plan != null ? plan.quantity : 0;
            return new ObjectResult(result);
        }


        /// <summary>
        /// 根据产品号查询工艺路径
        /// </summary>
        /// <param name="productId"></param>
        /// <returns></returns>
        [HttpGet]
        public IActionResult GetProcesses(int productId)
        {

            var result = _inspectStandardOptionRepository.GetRouteList(productId, ProjectId);
            if (result != null)
            {
                return new ObjectResult(result);
            }
            throw new BadRequestException(RequestEnum.RouteNotFound);
        }

        /// <summary>
        /// 根据id查询工艺路径
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        private string GetProcess(int id)
        {

            var result = _inspectStandardOptionRepository.GetRoute(id);
            if (result.Any())
            {
                return result.FirstOrDefault().name;
            }
            return "";
        }
        /// <summary>
        /// 查找检验类型
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        public IActionResult GetInspectionType()
        {
            var typeList = new List<ResponseType>();
            var type = _countSettingRepository.GetList(q => q.projectId == ProjectId && q.status == (int)RowState.Valid).ToList();
            if (type != null)
            {
                foreach (var item in type)
                {
                    var types = new ResponseType();
                    types.type_code = item.type_code;
                    types.type_name = item.type_name;
                    typeList.Add(types);
                }
                return new ObjectResult(typeList);
            }
            throw new BadRequestException(RequestEnum.StandardTypeNull);
        }

        /// <summary>
        /// 获取检验项
        /// </summary>
        /// <param name="productCode">产品编号</param>
        /// <param name="workStation">工位</param>
        /// <param name="code">检验类型</param>
        /// <returns></returns>
        [HttpGet]
        [NoTokenValidateFilter]
        public IActionResult GetInspection(string productCode, int workStation, string code)
        {
           
            var result = new List<ResponseTypes>();
            var standardList = _inspectStandard.GetList(q => q.productcode.Trim() == productCode && q.sectionid == workStation && q.status==(int)RowState.Valid).ToList();
            if (standardList.Any())
            {
                foreach (var item in standardList)
                {
                    var types = new ResponseTypes();
                    var inspectList = new List<inspect>();
                    var type = item.checktype.Split(",");
                    for (int i = 0; i < type.Length; i++)
                    {
                        if (type[i] == code)
                        {
                            if (item.value_type == 3)
                            {
                                var option = _inspectStandardOptionRepository.GetList(q => q.standardid == item.id && q.projectId == ProjectId
                                                                                               && q.status == (int)RowState.Valid).ToList();
                                foreach (var items in option)
                                {
                                    var inspect = new inspect();
                                    inspect.id = items.id;
                                    inspect.option = items.option;
                                    //inspect.unit = item.unit;
                                    inspectList.Add(inspect);
                                }
                            }
                            types.id = item.id;
                            types.name = item.item;
                            types.type = item.value_type==3?3:( item.value_type==1?2:1);
                            types.unit = item.unit;
                            types.inspect = inspectList;
                            result.Add(types);
                        }
                    }
                }
                return new ObjectResult(result);
            }
            throw new BadRequestException(RequestEnum.StandardTypeNull);
        }
        /// <summary>
        /// 单件检验提交
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult SaveOption([FromBody] RequestSaveOption request)
        {
            var guid = Guid.NewGuid().ToString();
            var treace = new SigerTrSnTrace();//_trSnTrace
            treace.SeqID = guid;
            treace.SN = request.SN;
            treace.Station = request.Station;//工站
            treace.UID = request.userId;
            treace.WO = request.WO;
            treace.Result = request.Results;
            treace.projectId = ProjectId;
            treace.ProductRoute = request.ProductRoute;//工序
            treace.ProductID = request.ProductID;
            treace.type = (int)TraceType.TraceBack;
            treace.TransDateTime = DateTime.Now;
            treace.LastUpdateTime = DateTime.Now;
            _trSnTrace.Insert(treace);
            foreach (var item in request.TraceDetials)
            {
                var traceDetail = new SigerTrSNTraceDetail();
                traceDetail.SN = request.SN;
                traceDetail.Item = item.Item;//值选项
                traceDetail.Value = item.Value+item.unit;//值
                traceDetail.Remarks = item.Result;//
                traceDetail.Item2 = item.id.ToString();//
                traceDetail.projectId = ProjectId;
                traceDetail.SeqID = guid;
                traceDetail.Item3 = request.type;//检验类型
                traceDetail.TransDateTime = DateTime.Now;
                traceDetail.LastUpdateTime = DateTime.Now;
                traceDetail.Result = EvenNoEnum.OK.ToString();
                _sigerTrSnTraceDetails.Insert(traceDetail);
            }

            if (_unitOfWork.Commit() > 0)
            {
                return new ObjectResult(CommonEnum.Succefull);
            }

            throw new BadRequestException(CommonEnum.Fail);
        }
        /// <summary>
        /// 辅料查询
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [HttpPost]
        [NoTokenValidateFilter]
        public IActionResult Accessories([FromBody] RequestAccessories request)
        {
            var pid = ProjectId;
            var result = new RequestAccess();
            var batchList = _snList.GetDataByBatch(request.batch,request.wo, pid).FirstOrDefault();

            if (batchList != null)
            {
                result.isPart = 1;
                result.batch = batchList.batch;
                result.id = batchList.id;
                result.name = batchList.name;
                result.number = batchList.number;
            }
            else
            {
                string[] sn = request.batch.Split('=');
                if (sn.Length == 2)
                {

                    var snList = _snList.GetDataBySn(sn[1], pid).FirstOrDefault();
                    if (snList != null)
                    {
                        var product = _sigerProjectProduct.Get(q => q.id == snList.ProductId && q.status == (int)RowState.Valid);
                        result.batch = snList.SN;
                        result.id = snList.id;
                        result.name = product != null ? product.name : "";
                        result.number = 1;
                    }

                }
                else
                {
                    var snList = _snList.GetDataBySn(request.batch, pid).FirstOrDefault();
                    if (snList != null)
                    {
                        var product = _sigerProjectProduct.Get(q => q.id == snList.ProductId && q.status == (int)RowState.Valid);
                        result.batch = snList.SN;
                        result.id = snList.id;
                        result.name = product != null ? product.name : "";
                        result.number = 1;
                    }
                    else
                    {

                        result.batch = request.batch;
                        result.id = 0;
                        result.name = "其他";
                        result.number = 1;

                    }

                }
                
            }

            return new ObjectResult(result);
        }



        /// <summary>
        /// 装配
        /// </summary>
        /// <param name="reqAssembleData"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult AssebelProduct([FromBody] RequestAssembleProduct reqAssembleData)
        {


            var uid = UserId;
            if (reqAssembleData.userId != 0)
            {
                uid = reqAssembleData.userId;

            }
            //检查sn合法性
            var snData = _snList.Get(f => f.SN.Equals(reqAssembleData.sn) && f.projectId == ProjectId &&
                                                                            f.status == (int)RowState.Valid);
            if (snData == null)
            {
                throw new BadRequestException(AccEnum.Busi_SN_Null);
            }
            var guid = Guid.NewGuid().ToString();
            //siger_tr_assemb_details表中添加记录
            var detail = new List<siger_tr_assemb_details>();
            var assembly = new siger_tr_assemb_details();
            assembly.busidate = DateTime.Now;
            assembly.guid = guid;
            assembly.projectId = ProjectId;
            assembly.section = reqAssembleData.SectionId;
            assembly.ispart = (int)ProductType.InPart;
            assembly.name = "";
            assembly.number = 1;
            assembly.sn = reqAssembleData.sn;
            uid = reqAssembleData.userId;
            detail.Add(assembly);
            foreach (var item in reqAssembleData.AccessoriesSn)
            {
                var assem = _sigetTrAssemblyDetailsRepository.GetList(q => q.sn == item.batch && q.projectId == ProjectId && q.status == (int)RowState.Valid).Sum(q => q.number);
                var mate = _sigetTrAssemblyDetailsRepository.GetNumber(item.batch, ProjectId).FirstOrDefault();
                var mateNumber = mate != null ? mate.number : 0;
                assembly = new siger_tr_assemb_details();
                assembly.busidate = DateTime.Now;
                assembly.guid = guid;
                assembly.projectId = ProjectId;
                assembly.section = reqAssembleData.SectionId;
                assembly.ispart = (int)ProductType.Part;
                assembly.name = item.name;
                assembly.number = item.number;
                assembly.sn = item.batch;
                assembly.uid = reqAssembleData.userId;
                detail.Add(assembly);
            }
            _sigetTrAssemblyDetailsRepository.Insert(detail);
            //    //插入Trace
            var trace = new SigerTrSnTrace
            {
                WO = reqAssembleData.wo,
                LastUpdateTime = DateTime.Now,
                TransDateTime = DateTime.Now,
                Station = reqAssembleData.SectionId,
                UID = uid,
                SeqID = guid,
                projectId = ProjectId,
                ProductID = snData.ProductId.ToString(),
                SN = reqAssembleData.sn,
                ProductRoute = reqAssembleData.ProductRouteId.ToInt(),
                type = (int)TraceType.TraceBack,
                Result = EvenNoEnum.OK.ToString()
            };
            _trSnTrace.Insert(trace);
            foreach (var item in reqAssembleData.AccessoriesSn)
            {
                var traceDetail = new SigerTrSNTraceDetail
                {
                    SeqID = guid,
                    SN = reqAssembleData.sn,
                    Item = item.batch,
                    Value = item.number.ToString(),
                    projectId = ProjectId,
                    LastUpdateTime = DateTime.Now,
                    TransDateTime = DateTime.Now,
                    Result = EvenNoEnum.OK.ToString()
                };
                _sigerTrSnTraceDetails.Insert(traceDetail);
            }
            if (_unitOfWork.Commit() > 0)
            {
                return new ObjectResult(CommonEnum.Succefull);
            }

            throw new BadRequestException(CommonEnum.Fail);
        }
        /// <summary>
        /// 报表展示
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [HttpPost]
        [NoTokenValidateFilter]
        public IActionResult QueryData([FromBody] RequestQueryData request)
        {
            var assembList = new List<ResponseAssembling>();
            var inspectionList = new List<ResponseInspectionData>();
            var assemb = _sigetTrAssemblyDetailsRepository.GetList(q => q.ispart == (int)ProductType.InPart
                                                                                                  && q.status == (int)RowState.Valid
                                                                                                  && q.sn == request.sn).FirstOrDefault();
  
            var snlist = _snList.Get(f => f.SN == request.sn);
            if (snlist == null)
            {
                throw new BadRequestException(AccEnum.Busi_SN_Null);
            }
            //基础数据
            var product = _sigerProjectProduct.Get(q => q.code == snlist.ProductCode && q.status == (int)RowState.Valid);
            var result = new ResponseProduct();
            result.sn = snlist.SN;
            result.name = product != null ? product.name : "";
            result.WO = snlist.WO;
            result.dateTime = assemb != null ? assemb.busidate.ToString(ParameterConstant.DateTimeFormat) : "";
            result.drawingcode = product != null ? product.drawingcode : "";
            result.InspectionData = inspectionList;
            result.AssembList = assembList;
            //装配
            var assembs = _sigetTrAssemblyDetailsRepository.GetList(q => q.ispart == (int)ProductType.InPart
            && q.status == (int)RowState.Valid
            & q.sn == request.sn).ToList();
            if (assembs.Any())
            {
                foreach (var item in assembs)
                {
                    var trace = _trSnTrace.Get(q => q.SeqID == item.guid);
                    var traceDetail = _sigerTrSnTraceDetails.Get(q => q.SeqID == item.guid && q.Item == item.sn);
                    var assembss = _sigetTrAssemblyDetailsRepository.GetList(q => q.ispart == (int)ProductType.Part
                                                                                                            && q.status == (int)RowState.Valid
                                                                                                            & q.guid == item.guid).ToList();
                    foreach (var req in assembss)
                    {
                        var status = trace.Station;
                        var levelSection = "";
                        while (status > 0)
                        {
                            var level = _sigerProjectLevelSectionRepository.Get(q => q.id == status);
                            if (level != null)
                            {
                                if (level.parentid == 0)
                                {
                                    levelSection = level.title + "/" + levelSection;
                                    status = -1;
                                }
                                else
                                {
                                    if (levelSection == "")
                                    {
                                        levelSection = level.title;
                                    }
                                    else
                                    {
                                        levelSection = level.title + "/" + levelSection;
                                    }

                                    status = level.parentid;
                                }
                            }
                            else
                            {
                                status = -1;
                            }
                        }
                        var ProductRoute = GetProcess(trace.ProductRoute);

                        var nickname = _sigerUserRepository.Get(q => q.id == req.uid) != null ? _sigerUserRepository.Get(q => q.id == req.uid).nickname : "";
                        var sn = _snList.Get(q => q.SN == req.sn);
                        var assemDrawcode = string.Empty;
                        if (sn != null)
                        {
                            var assemProduct = _sigerProjectProduct.Get(q => q.code == sn.ProductCode && q.status == (int)RowState.Valid);
                            assemDrawcode = assemProduct != null ? assemProduct.drawingcode : "";
                        }
                        var assembling = new ResponseAssembling
                        {
                            name = req.name,
                            drawingcode = assemDrawcode,// product.drawingcode,
                            dateTime = req.busidate,
                            number = req != null ? req.number.ToString() : "0",
                            batch = req.sn,
                            UID = nickname,
                            section = levelSection,
                            type = sn != null ? 1 : 0,
                            ProductRoute = ProductRoute != null ? ProductRoute : ""
                        };

                        assembList.Add(assembling);

                    }
                }
            }

            //检验
            var assembLists = _sigetTrAssemblyDetailsRepository.GetList(q => q.ispart == (int)ProductType.InPart
                                                                                                  && q.status == (int)RowState.Valid
                                                                                                  && q.sn == request.sn).Select(q => q.guid).ToList();
            var trTraceList = _trSnTrace.GetList(q => !assembLists.Contains(q.SeqID) && q.SN == request.sn
                                                                                   && q.status == (int)RowState.Valid).ToList();
            if (trTraceList.Any())
            {
                foreach (var item in trTraceList)
                {
                    var traceDetialList = new List<RequestTraceDetial>();
                    var traceDetail = _sigerTrSnTraceDetails.GetList(q => q.SeqID == item.SeqID && q.status == (int)RowState.Valid).ToList();
                    if (traceDetail.Any())
                    {
                        foreach (var items in traceDetail)
                        {
                            var traceDetials = new RequestTraceDetial()
                            {
                                id = items.id,
                                Value = items.Item!="检测结果"?items.Value:items.Value.Trim()=="1"?"合格":items.Value.Trim()=="0"?"不合格":"",
                                Result = items.Result,
                                Item = items.Item,
                            };
                            traceDetialList.Add(traceDetials);
                        }
                        var status = item.Station;
                        var levelSection = "";
                        while (status > 0)
                        {
                            var level = _sigerProjectLevelSectionRepository.Get(q => q.id == status);
                            if (level != null)
                            {
                                if (level.parentid == 0)
                                {
                                    levelSection = level.title + "/" + levelSection;
                                    status = -1;
                                }
                                else
                                {
                                    if (levelSection == "")
                                    {
                                        levelSection = level.title;
                                    }
                                    else
                                    {
                                        levelSection = level.title + "/" + levelSection;
                                    }

                                    status = level.parentid;
                                }
                            }
                            else
                            {
                                status = -1;
                            }
                        }
                        var typeCode = traceDetail.FirstOrDefault().Item3;//得到工序id
                        var type = _countSettingRepository.GetList(q => q.type_code.ToString() == typeCode && q.status == (int)RowState.Valid).FirstOrDefault();
                        var ProductRoute = GetProcess(item.ProductRoute);
                        var productObjMr = _sigerProjectProduct.Get(q => q.id == item.ProductID.ToInt() && q.status == (int)RowState.Valid);
                        var name = _sigerUserRepository.Get(q => q.id == item.UID) != null ? _sigerUserRepository.Get(q => q.id == item.UID).nickname : "";
                        var inspectionData = new ResponseInspectionData()
                        {
                            name = productObjMr != null ? productObjMr.name : "",
                            drawingcode = product != null ? product.drawingcode : "",
                            dateTime = item.TransDateTime,
                            UID = name,
                            result = item.Result,
                            ProductRoute = ProductRoute != null ? ProductRoute : "",
                            section = levelSection,
                            TraceDetials = traceDetialList,
                            checkType = type != null ? type.type_name : "",
                        };
                        inspectionList.Add(inspectionData);
                    }
                }
            }

            return new ObjectResult(result);
        }
        /// <summary>
        /// 批次领料查询
        /// </summary>
        /// <param name="AssistMaterials"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult GetAssistMaterialsList([FromBody] RequestAssistMaterials AssistMaterials)
        {
            var result = _snList.GetDataAssistMaterials(AssistMaterials, ProjectId);
            return new PagedObjectResult(result.Data, result.Total);
        }

        /// <summary>
        /// 获取所有名称
        /// </summary>
        /// <param name="ass"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult GetAllName([FromBody] RequestGetName ass)
        {
            var result = _sigerTrAssistMaterialsRepository.GetDataByName(ass);

            return new ObjectResult(result);
        }

        /// <summary>
        /// 打印次数
        /// </summary>
        /// <param name="print"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult PrintCount([FromBody] RequestPrint print)
        {


            if (print.ids.Count == 0)
                throw new BadRequestException(RequestEnum.ParameterMiss);

            foreach (var item in print.ids)
            {
                if (print.type == 1)
                {
                    var snList = _snList.Get(q => q.id == item);
                    if (snList != null)
                    {
                        snList.printCount = snList.printCount + 1;
                        _snList.Update(snList);
                    }
                }
                else
                {
                    var assist = _sigerTrAssistMaterialsRepository.Get(q => q.id == item);
                    if (assist != null)
                    {
                        assist.printCount = assist.printCount + 1;
                        _sigerTrAssistMaterialsRepository.Update(assist);
                    }
                }
            }
            if (_unitOfWork.Commit() > 0)
                return new ObjectResult(CommonEnum.Succefull);
            else
                throw new BadRequestException(CommonEnum.Fail);
        }
        /// <summary>
        /// 工单类别
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        public IActionResult WorkOrder()
        {
            var result = _snList.GetDataWorkOrder(ProjectId);
            return new ObjectResult(result);
        }


        /// <summary>
        /// 根据sn或wo查询数据
        /// </summary>
        /// <param name="req"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult CheckAssemble([FromBody] RequestAssembleBySn req)
        {

            if (req.ToExcel == 0)
            {
                var woQuantity = _sigetTrAssemblyDetailsRepository.GetAssembleBySn(req, ProjectId);
                if (woQuantity == null)
                    throw new BadRequestException(AccEnum.Data_Null);

                var queryList = new List<RequestAssembleBySnList>();
                foreach (var item in woQuantity.Data)
                {

                    var status = int.Parse(item.Line);
                    var levelSection = "";
                    while (status > 0)
                    {
                        var level = _sigerProjectLevelSectionRepository.Get(q => q.id == status);
                        if (level != null)
                        {
                            if (level.parentid == 0)
                            {
                                levelSection += level.title;
                                status = -1;
                            }
                            else
                            {
                                levelSection += level.title + "/";
                                status = level.parentid;
                            }
                        }
                        else
                        {
                            status = -1;
                        }
                    }
                    item.Line = levelSection;
                    queryList.Add(item);
                }
                return new PagedObjectResult(queryList, woQuantity.Total, req.page, req.pagesize);
            }
            else
            {
                var data = _sigetTrAssemblyDetailsRepository.GetAssembleBySn(req, ProjectId);
                if (data == null)
                    throw new BadRequestException(AccEnum.Data_Null);

                var datalist = new List<AssembData>();
                data.Data.ToList().ForEach(da => datalist.Add(Mapper<RequestAssembleBySnList, AssembData>.Map(da)));
               

                var rootDir = FileSystemHelper.GetPhysicalFolders( FileSystemHelper.CommonFileSetting.PhysicalFolder,FileSystemHelper.ExportFileName);
                
                if (datalist.Any())
                {
                    EpPlusExcelHelper<AssembData> helper = null;
                    try
                    {
                        helper = new EpPlusExcelHelper<AssembData>();
                        var temporaryFileName = $"{DateTime.Now:yyyyMMddHHmmss}.xlsx";
                        helper.GenerateExcel(datalist, Path.Combine(rootDir, temporaryFileName));
                        return new ObjectResult($"{FileSystemHelper.CommonFileSetting.RequestPath}/{FileSystemHelper.ExportFileName}/{temporaryFileName}");
                    }
                    catch (Exception e)
                    {
                        Logger.WriteLineError("Export failed,error:" + e);
                        throw new BadRequestException(RequestEnum.ExportFailed);
                    }
                    finally
                    {

                        helper?.Dispose();
                    }
                }
                throw new BadRequestException(CommonEnum.RecordNotFound);
            }
        }

        /// <summary>
        /// 根据时间段查询
        /// </summary>
        /// <param name="req"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult CheckAssembleByDate([FromBody] RequestAssembleData req)
        {
            var result = _sigetTrAssemblyDetailsRepository.GetAssembleData(req, ProjectId);
            var queryList = new List<RequestAssembleBySnList>();
            foreach (var item in result.Data)
            {
                var status = int.Parse(item.Line);
                var levelSection = "";
                while (status > 0)
                {
                    var level = _sigerProjectLevelSectionRepository.Get(q => q.id == status);
                    if (level != null)
                    {
                        if (level.parentid == 0)
                        {
                            levelSection += level.title;
                            status = -1;
                        }
                        else
                        {
                            levelSection += level.title + "/";
                            status = level.parentid;
                        }
                    }
                    else
                    {
                        status = -1;
                    }
                }
                item.Line = levelSection;
                queryList.Add(item);
            }
            return new PagedObjectResult(queryList, result.Total, req.page, req.pagesize);
        }


    }
}
