﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Microsoft.CodeAnalysis;
using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Repositories.Interface;
using Siger.Middlelayer.AccRepository.Request;
using Siger.Middlelayer.Common;
using Siger.ApiCommon.Filters;
using Siger.Middlelayer.Common.Extensions;
using Siger.Middlelayer.Log;
using Siger.Middlelayer.Common.ModuleEnum;
using Siger.Middlelayer.Repository;
using Siger.Middlelayer.Repository.Repositories.Interface;
using Siger.Middlelayer.Share.Constant;
using Siger.Middlelayer.Share.Enum.ModuleEnum;
using static Siger.Middlelayer.Share.Enum.ModuleEnum.Automation;
using Siger.Middlelayer.Repository.Entities;
using NPOI.SS.Formula.Functions;
using Siger.Middlelayer.AccRepository.Response;
using Siger.Middlelayer.Common.Helpers;
using NPOI.SS.Formula;

namespace Siger.ApiACC.Controllers
{
    [NoTokenValidateFilter]
    public class AutomationController : LaisiBaseController
    {
        private readonly IUnitOfWork _unitOfWork;
        private readonly ISigerProjectLevelSectionRepository _sigerProjectLevelSection;
        private readonly IAutomationLineMode _automationLineMode;
        private readonly IAutomationMachineStatus _automationMachineStatus;
        private readonly ISigerDict _sigerDict;
        private readonly IAutomationTaskListRepository _automationTaskList;
        private readonly ISigerProjectMachineAttributionRepository _sigerProjectMachineAttribution;
        private readonly IAutomationFixtureMonitor _automationFixtureMonitor;
        private readonly IAutomationLocationRepository _automationLocation;
        private readonly IProductionBeatSetRepository _productionBeatSet;
        private readonly IAutomationFixtureToolsProductRepository _automationFixtureToolsProduct;
        private readonly IAutomationFixtureToolsRepository _automationFixtureTools;
        private readonly IProductRouteRepository _productRoute;

        public AutomationController(IUnitOfWork unitOfWork,ISigerProjectLevelSectionRepository sigerProjectLevelSection,IAutomationLineMode automationLineMode,IAutomationMachineStatus automationMachineStatus,ISigerDict sigerDict,IAutomationTaskListRepository automationTaskList,
            ISigerProjectMachineAttributionRepository sigerProjectMachineAttribution, IAutomationFixtureMonitor automationFixtureMonitor, IAutomationLocationRepository automationLocation, IProductionBeatSetRepository productionBeatSet, IAutomationFixtureToolsProductRepository automationFixtureToolsProduct,
         IAutomationFixtureToolsRepository automationFixtureTools, IProductRouteRepository productRoute)
        {
            _unitOfWork = unitOfWork;
            _sigerProjectLevelSection = sigerProjectLevelSection;
            _automationLineMode = automationLineMode;
            _automationMachineStatus = automationMachineStatus;
            _sigerDict = sigerDict;
            _automationTaskList = automationTaskList;
            _sigerProjectMachineAttribution = sigerProjectMachineAttribution;
            _automationFixtureMonitor = automationFixtureMonitor;
            _automationLocation = automationLocation;
            _productionBeatSet = productionBeatSet;
            _automationFixtureToolsProduct = automationFixtureToolsProduct;
            _automationFixtureTools = automationFixtureTools;
            _productRoute = productRoute;
        }
 
        /// <summary>
        /// 设备状态接口 用于 保存 设备当前可用状态
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult MachineStatus([FromBody]RequestAutomationMachine request)
        {
            var machineAttr = _sigerProjectMachineAttribution.Get(f => f.projectid == PID && f.machine == request.machineid);
            if (machineAttr==null)
            {
                throw new BadRequestException(ConfigEnum.MachineAttributionNotFound);
            }
            var exitsObj = _automationMachineStatus.Get(f => f.machineid == request.machineid);
            if (exitsObj==null)
            {
                _automationMachineStatus.Insert(new siger_automation_machine_status{ 
                     section=machineAttr.station,
                     machineid=request.machineid,
                     projectId=PID,
                     updatetime=DateTime.Now,
                     enable=request.enable==1?1:0,
                     status=request.status
                });
            }else
            {
                exitsObj.enable = request.enable;
                exitsObj.status = request.status;
                exitsObj.updatetime = DateTime.Now;
                _automationMachineStatus.Update(exitsObj);
            }
           
         
            if (_unitOfWork.Commit() > 0)
            {
                // 设备空闲，或者完成时触发 自动任务
                if (request.enable == 1)
                {
                    if (request.status == (int)Automation.MachineStatus.Waiting || request.status == (int)Automation.MachineStatus.Complated)
                    {
                        var stationDicts = _sigerDict.GetDataByCat(AccDictCost.Automation, PID);
                        if (!stationDicts.Any())
                        {
                            Logger.WriteLineInfo($"AutoProcess 未配置设备类型字典");
                            throw new BadRequestException(AccEnum.AutomationDictNotfound);
                        }
                        //Logger.WriteLineInfo($"设备状态更变{request.status}触发");
                        if (_automationTaskList.CanTask(PID, machineAttr.station))
                        {
                            var uploadStation = stationDicts.Where(f => f.dkey == DictKeyValConst.UploadloadStation);
                            var uploadStations = uploadStation.Select(f => f.dval.ToInt()).ToList();

                            if (!uploadStations.Contains(machineAttr.station))
                            {
                                var tasklist = _automationTaskList.GetList(f => f.projectId == PID && f.status < (int)TaskResultStatus.Complated);

                                if (!tasklist.Any())
                                {
                                    var section = _sigerProjectLevelSection.Get(f => f.id == machineAttr.station);
                                    if (section != null)
                                    {
                                        Logger.WriteLineInfo($"MachineStatus 设备 {section.title}状态 触发自动任务检查");
                                        AutoProcess(section.parentid, stationDicts);
                                    }
                                }
                            }
                        }
                    }
                }
                return new ObjectResult(CommonEnum.Succefull);
            }
            else
            {
                throw new BadRequestException(CommonEnum.Fail);
            }
        }

        /// <summary>
        /// 产线模式  0:手动模式 /1:自动模式（产生自动任务）
        /// </summary>
        /// <param name="line"></param>
        /// <param name="mode"></param>
        /// <returns></returns>
        [HttpGet]
        public IActionResult LineMode(int line, int mode)
        {
            var exitObj = _automationLineMode.Get(f => f.section == line);
            if (exitObj == null)
            {
                _automationLineMode.Insert(new siger_automation_line_mode
                {
                    section = line,
                    projectId = PID,
                    status = 1, 
                    updatetime = DateTime.Now,
                    mode = mode
                });
            }
            else
            {
                exitObj.updatetime = DateTime.Now;
                exitObj.mode = mode;
                _automationLineMode.Update(exitObj);
            }
        
            if (_unitOfWork.Commit() > 0)
            {
                if (mode == 1)
                {
                    //TODO
                    //手动-》自动 时
                    //task 无任务时候 ，根据设备状态创建任务

                    var stationDicts = _sigerDict.GetDataByCat(AccDictCost.Automation, PID);
                    if (!stationDicts.Any())
                    {
                        Logger.WriteLineInfo($"AutoProcess 未配置设备类型字典");
                        throw new BadRequestException(AccEnum.AutomationDictNotfound);
                    }
                    
                    var tasklist = _automationTaskList.GetList(f => f.projectId == PID && f.status < (int)TaskResultStatus.Complated);
                    if (!tasklist.Any())
                    {
                        Logger.WriteLineInfo($"LineMode Mode=1 触发自动任务检查");
                        AutoProcess(line, stationDicts);
                    }
                }
                return new ObjectResult(CommonEnum.Succefull);
            }
            else
            {
                throw new BadRequestException(CommonEnum.Fail);
            }
        }

        /// <summary>
        ///  产线 需要检验
        /// </summary>
        /// <param name="line"></param>
        /// <param name="enable"></param>
        /// <returns></returns>
        [HttpGet]
        public IActionResult Inspect(int line, int enable)
        {
            var exitObj = _automationLineMode.Get(f => f.section == line);
            if (exitObj == null)
            {
                throw new BadRequestException(CommonEnum.RecordNotFound);
            }

            exitObj.updatetime = DateTime.Now;
            exitObj.inspect = enable;

            if (_unitOfWork.Commit() > 0)
                return new ObjectResult(CommonEnum.Succefull);
            else
                throw new BadRequestException(CommonEnum.Fail);
        }
        /// <summary>
        /// 任务状态接口  用于保存PLC 实时任务状态 ()
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public IActionResult TaskResult([FromBody]RequestAutomationTaskResult request)
        {
            //1.检查Tasklist
            var taskObj = _automationTaskList.Get(f => f.no== request.guid);
            if (taskObj == null)
            {
                throw new BadRequestException(CommonEnum.RecordNotFound);
            }
            if (taskObj.status==(int)TaskResultStatus.Complated)
            {
                throw new BadRequestException(AccEnum.AutoTaskDone);
            }
            var stationDicts = _sigerDict.GetDataByCat(AccDictCost.Automation, PID);
            if (!stationDicts.Any())
            {
                Logger.WriteLineInfo($"AutoProcess 未配置设备类型字典");
                throw new BadRequestException(AccEnum.AutomationDictNotfound);
            }

            //更新Tasklist
            PlCfeeback(taskObj, request.status, stationDicts);

            if (_unitOfWork.Commit() <= 0)
            {
                throw new BadRequestException(CommonEnum.Fail);
            }

            //还有未完成任务 退出 等待任务下发
            if (!_automationTaskList.CanTask(PID, taskObj.sectionid))
            {
                return new ObjectResult(CommonEnum.Succefull);
            }
            //3.Tasklist 任务全部完成 ,创建自动任务
            var section = _sigerProjectLevelSection.Get(f => f.id == taskObj.sectionid);
            if (section != null)
            {
                AutoProcess(section.parentid, stationDicts, taskObj);
            }

            return new ObjectResult(CommonEnum.Succefull);
        }

        void PlCfeeback(siger_automation_task_list taskObj,int status, IEnumerable<SigerTrDict> stationDicts)
        {
            //2.更新状态
            taskObj.status = status;
            taskObj.completetime = DateTime.Now;
            _automationTaskList.Update(taskObj);

            var monitor = _automationFixtureMonitor.Get(f => f.section == taskObj.sectionid);
            //PLC 反馈结束. 
            if (status == (int)TaskResultStatus.Complated)
            {
                var uploadStation = stationDicts.Where(f => f.dkey == DictKeyValConst.UploadloadStation);
                var uploadStations = uploadStation.Select(f => f.dval).ToList();

                if (taskObj.action == TaskAction.Step_SXLW_LK)
                {
                    // 业务入口： 上料位-》 入库 如果是上料工装 安装完成 ,绑定 储位与装配
                    if (uploadStations.Exists(f => f.Contains(taskObj.sectionid.ToString())))
                    {
                        var location = _automationLocation.Get(f => f.fixturetools == taskObj.fixtureguid);
                        if (location == null)
                        {
                            Logger.WriteLineInfo($"PlCfeeback 未找到该工装储位信息");
                            throw new BadRequestException(AccEnum.MachineDisable);
                        }
                        location.fixturetools = taskObj.fixtureguid;
                        location.fixturename = taskObj.fixturename;
                        location.ordernumber = taskObj.ordercode;
                        location.productcode = taskObj.productcode;
                        location.productid = taskObj.productid;
                        location.routeid = taskObj.route;
                        location.sn = taskObj.sn;
                        _automationLocation.Update(location);
                    }

                }
                if (monitor != null && taskObj.action == TaskAction.Step_SXLW_LK)
                {
                    monitor.section = 0;
                }

                //上料上下料设备状态为后台控制，CNC是PLC控制
                var machineStatus = _automationMachineStatus.Get(f => f.section == taskObj.sectionid && f.auto==0);
                if (machineStatus != null)
                {
                    machineStatus.status = (int)Automation.MachineStatus.Waiting;
                    _automationMachineStatus.Update(machineStatus);
                }

            }
            
            if (monitor != null)
            {
                monitor.status = status;
                monitor.route = taskObj.route;
                monitor.fixtureguid = taskObj.fixtureguid;
                monitor.fixturename = taskObj.fixturename;
                _automationFixtureMonitor.Update(monitor);
            }



        }

        /// <summary>
        /// 创建自动 Task任务
        /// </summary>
        /// <param name="line"></param>
        /// <param name="fixture"></param>
        /// <param name="stationDicts"></param>
        /// <param name="tasklist"></param>
        void AutoProcess(int line,IEnumerable<SigerTrDict> stationDicts,siger_automation_task_list tasklist=null)
        {
            var lineMode = _automationLineMode.Get(f => f.projectId == PID && f.section == line);
            if (lineMode==null)
            {
                Logger.WriteLineInfo($"AutoProcess 产线模式未找到");
                throw new BadRequestException(AccEnum.LineModeNotfound);
            }
            if (lineMode.mode==0)
            {
                Logger.WriteLineInfo($"AutoProcess 手动模式 不能创建自动任务");
                //手动模式时 退出
                return;
            }
            /*
            //自动Task任务 顺序 
            //1.清洗机下料
            //2.其他设备上料
            //3.其他设备下料 
            */
            var updownDic= stationDicts.Where(s => s.dkey == DictKeyValConst.UploadloadStation);
            var uploadStations = updownDic.Select(f => f.dval.ToInt()).ToList();
            /* 自动任务创建只有CNC 设备;排除上料设备（手动任务） */
            var dictClean = stationDicts.FirstOrDefault(s=>s.dkey==DictKeyValConst.CleanStation);
            if (dictClean==null)
            {
                Logger.WriteLineInfo($"AutoProcess 未配置清洗机字典");
                return;
            }
            // 获取可用 设备状态列表 排除上料工位
            var machineStatusList = _automationMachineStatus.GetList(f => f.projectId == PID && f.auto==1 && !uploadStations.Contains(f.section) && f.enable == 1);
            if (!machineStatusList.Any())
            {
                Logger.WriteLineInfo($"AutoProcess 无可用状态的设备");
                return;
            }
            //优先级1 ：清洗机完成 。待下料
            var cleanMachine = machineStatusList.FirstOrDefault(f => f.section == dictClean.dval.ToInt());
            if (cleanMachine!=null)
            {
                if (cleanMachine.status == (int)Automation.MachineStatus.Complated)
                {
                    Logger.WriteLineError($"AutoProcess 有清洗机{ cleanMachine.section}完成，创建清洗机Task");
                    if (tasklist == null)
                    {
                        Logger.WriteLineError($"AutoProcess Tasklist 为空");
                        return;
                    }
                    CreateTask(cleanMachine.section, TaskActionType.Unload, TaskAction.Step_QXJ_LK, tasklist.fixtureguid, tasklist.ordercode, tasklist.sn, "无程序", tasklist.productid, tasklist.productcode, tasklist.locationid, tasklist.route);
                    return; //完成当前任务 退出
                }
            }
            //优先级2 ：其他设备待上料 (立库->加工中心)
            var freeMachine = machineStatusList.Where(f=>f.status==(int)Automation.MachineStatus.Waiting);
            if (freeMachine != null)
            {
                Logger.WriteLineError($"AutoProcess 普通空闲，创建普通设备上料Task");
                var location = SelectLocation(freeMachine.Select(s=>s.machineid).ToList());
                if (location != null)
                {
                    // * 更新下一个工序到储位 
                    var locationObj = _automationLocation.Get(f => f.id == location.lid);
                    if (locationObj != null)
                    {
                        var doneRoute = _productRoute.Get(f => f.id == location.route);
                        if (doneRoute == null)
                            return;

                        var productRoutes = _productRoute.GetList(f => f.projectId == PID && f.productId == location.productId && f.status == (int)RowState.Valid && f.serialNumber > doneRoute.serialNumber);
                        if (!productRoutes.Any())
                        {
                            locationObj.route = string.Empty;
                        }
                        else
                        {
                            var nextRoute = productRoutes.OrderBy(d => d.serialNumber).FirstOrDefault();

                            locationObj.routeid = nextRoute != null ? nextRoute.id : 0;
                            locationObj.route = nextRoute != null ? nextRoute.name : "";
                        }
                        _automationLocation.Update(locationObj);

                        CreateTask(location.section, TaskActionType.Load, TaskAction.Step_LK_JGZX, location.fixture, location.ordernumber, location.sn, location.pn, location.productId, location.productCode, location.location,location.route);
                        return; //完成当前任务 退出
                    }
                }
            }
            //优先级3：其他设备下料  (加工中心 ->清洗机)
            if (cleanMachine != null)
            {
                var fullMachine = machineStatusList.FirstOrDefault(f => f.status == (int)Automation.MachineStatus.Complated);
                if (fullMachine != null && cleanMachine.status==(int)Automation.MachineStatus.Waiting)
                {
                    Logger.WriteLineError($"AutoProcess 清洗机空闲，创建普通设备下料到清洗机Task ");
                    if (tasklist==null)
                    {
                        Logger.WriteLineError($"AutoProcess Tasklist 为空");
                        return;
                    }
                    CreateTask(fullMachine.section,TaskActionType.Unload, TaskAction.Step_JGZX_QXJ, tasklist.fixtureguid,tasklist.ordercode, tasklist.sn,tasklist.programnumber,tasklist.productid,tasklist.productcode,tasklist.locationid,tasklist.route);

                    return; //完成当前任务 退出
                }
            }
        }


        /// <summary>
        /// 创建自动任务
        /// </summary>
        /// <param name="section"></param>
        /// <param name="actionType"></param>
        /// <param name="taskAction"></param>
        /// <param name="guid">工装GUID</param>
        /// <param name="orderno">订单</param>
        /// <param name="sn">工件</param>
        /// <param name="productCode">产品CODE</param>
        /// <param name="locationid">储位ID</param>
        void CreateTask(int section,TaskActionType actionType, TaskAction taskAction,string guid,string orderno,string sn,string program,int productId,string productCode,int locationid,int route)
        {
            var taskNo = _automationTaskList.CrateTaskNumber(Automation.TaskTrigerType.Auto);
            _automationTaskList.Insert(new siger_automation_task_list
            {
                no= taskNo,
                projectId = PID,
                sectionid = section,
                trigger = TaskTrigerType.Auto,
                action = taskAction,
                actiontype = ExcueType.None,
                tasktype = actionType,
                triggertime = DateTime.Now,
                completetime = DateTime.MinValue,
                operatetime = DateTime.MinValue,
                send = 0,
                operater = 0,
                status = 1,
                fixtureguid= guid,
                productid = productId,
                productcode = productCode,
                programnumber=program,
                locationid= locationid,
                ordercode= orderno,
                sn= sn, 
                remark= EnumHelper.GetEnumDesc(taskAction),
                route=route

            });
            var monitor = _automationFixtureMonitor.Get(f => f.section == section);
            if (monitor == null)
            {
                _automationFixtureMonitor.Insert(new siger_automation_fixture_tools_monitor
                {
                    projectId=PID,
                    section=section,
                    fixtureguid=guid,
                    productId=productId,
                    productCode=productCode,
                    locationId=locationid,
                    createtime=DateTime.Now,
                    ordernumber=orderno,
                    route=route,
                    status=1,
                    sn=sn,
                    taskno=taskNo,
                });
            }
            else
            {
                monitor.sn = sn;
                monitor.route = route;
                monitor.locationId = locationid;
                monitor.productCode = productCode;
                monitor.productId = productId;
                monitor.fixtureguid = guid;
                monitor.taskno = taskNo;
                _automationFixtureMonitor.Update(monitor);
            }


            if (_unitOfWork.Commit() > 0)
                Logger.WriteLineInfo($"CreateTask sectionId:{section}工站 {EnumHelper.GetEnumDesc(taskAction)} 完成");
            else
                Logger.WriteLineInfo($"CreateTask sectionId:{section}工站 {EnumHelper.GetEnumDesc(taskAction)}失败");
        }
        /// <summary>
        /// 自动匹配储位 储位 ->CNC 
        /// </summary>
        ResponseAutomationLocationRouteInfo SelectLocation(List<int> machines)
        {
            // 当前空闲设备能加工的产品
            var beats = _productionBeatSet.GetList(f => f.projectID == PID && machines.Contains(f.machineID)  && f.status==(int)RowState.Valid).ToList();
            var TempList = new List<ResponseAutoRouteInfo>();
            foreach (var b in beats)
            {
                var autoLocation = _automationLocation.Get(f => f.projectId == b.projectID && !string.IsNullOrEmpty(f.sn) && f.routeid == b.route_number.ToInt() && f.productid == b.product_name.ToInt());
                if (autoLocation == null)
                    continue;
                TempList.Add(new ResponseAutoRouteInfo
                {
                     FixtureGuid=autoLocation.fixturetools,
                     FixtureName=autoLocation.fixturename,
                     Section=b.section_id,
                     Machine=b.machineID,
                     Pn=b.process_number,
                     ProductId=b.product_name.ToInt(),
                     ProductName=b.product_name_text,
                     Location=autoLocation.locationid,
                     Route=b.route_number.ToInt(),
                     RouteName=b.route_name,
                     OrderNo=autoLocation.ordernumber,
                     Sn=autoLocation.sn,
                     LId=autoLocation.id
                });
            }

            var ordernos = TempList.Select(f => f.OrderNo).ToList();

           

            // 取产品交期最近的订单
            var planOrder = _automationFixtureToolsProduct.GetDeliveryOrder(ordernos, PID);
            if (!planOrder.Any())
            {
                Logger.WriteLineError($"SelectLocation 未找到最近订单号信息");
                return null;
            }
            var order = planOrder.FirstOrDefault();
            var autoRouteInfo = TempList.Where(f => f.OrderNo == order.ordernumber).OrderBy(d=>d.Sn);
            var result = autoRouteInfo.FirstOrDefault();
            return new ResponseAutomationLocationRouteInfo
            {
                section=result.Section,
                machine=result.Machine,
                fixture = result.FixtureGuid,
                fixturename = result.FixtureName,
                ordernumber =result.OrderNo,
                location=result.Location,
                productId=result.ProductId,
                //productCode=result.productcode,
                productName = result.ProductName,
                sn =result.Sn,
                pn= result.Pn,
                route=result.Route,
                lid=result.LId
            };
        }



    }
}
