﻿using Siger.Middlelayer.AccRepository;
using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.CncRepository;
using Siger.Middlelayer.Repository;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Share.Enum.ModuleEnum;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using static Siger.Middlelayer.Share.Enum.ModuleEnum.Automation;

namespace Siger.ApiACC.Tasks
{
    public class DBhelper : IDisposable
    {
       

        private readonly ApiCncDbContext CncDbContext;
        private readonly ApiAccDbContext AccDbContext;
        private readonly ApiConfigDbContext ConfigDbContext;

        public DBhelper()
        {
            CncDbContext = new ApiCncDbContext();
            AccDbContext = new ApiAccDbContext();
            ConfigDbContext = new ApiConfigDbContext();
        }

        public siger_automation_line_mode GetLineMode(int projectId)
        {
            return AccDbContext.siger_automation_line_mode.FirstOrDefault(f => f.projectId == projectId);
        }
        /// <summary>
        /// 获取未推送tasklist
        /// </summary>
        /// <param name="projectId"></param>
        /// <returns></returns>
        public IEnumerable<siger_automation_task_list> GetTaskList(int projectId)
        {
            var query = from q in AccDbContext.siger_automation_task_list
                        join l in AccDbContext.siger_project_level_section on q.sectionid equals l.id
                        join lm in AccDbContext.siger_automation_line_mode on l.parentid equals lm.section
                        where q.projectId == projectId && lm.mode == 1 && q.send==0
                        select q;
            return query;
        }
        public bool CanTask(int projectId)
        {
            var query = from q in AccDbContext.siger_automation_task_list
                        where q.projectId == projectId && q.send==1 && q.status<(int)TaskResultStatus.Complated
                        select q;
            return !query.Any();
        }
        public siger_automation_fixture_tools_monitor GetMonitor(int section)
        {
            return AccDbContext.siger_automation_fixture_tools_moniter.FirstOrDefault(f => f.section == section);
        }
        public bool UpdateTask(siger_automation_task_list taskNo)
        {
            AccDbContext.siger_automation_task_list.Update(taskNo);
            return AccDbContext.SaveChanges() > 0;
        }
        public siger_project_level_section GetLevelsection(int id)
        {
            return AccDbContext.siger_project_level_section.FirstOrDefault(f => f.id==id);
        }

        public siger_project_machine_attribution GetAttribution(int section)
        {
            return AccDbContext.siger_project_machine_attribution.FirstOrDefault(f => f.station==section && f.status==1);
        }
        public siger_automation_fixture_tools GetFixture(string guid)
        {
            return AccDbContext.siger_automation_fixture_tools.FirstOrDefault(f => f.guid==guid && f.status == 1);
        }
        public void Dispose()
        {
            CncDbContext?.Dispose();
            AccDbContext?.Dispose();
            ConfigDbContext?.Dispose();
        }

    }
}
