﻿using System;
using System.IO;
using Microsoft.Extensions.Configuration;
using Siger.Middlelayer.Common.AppSettings;

namespace Siger.ApiCommon.Utilities
{
    public class Config<T> where T : SettingBase
    {
        public static T Get()
        {
            var path = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "Setting", "CommonSetting.ini");
            if (!File.Exists(path))
            {
               throw new FileNotFoundException("can not found Setting.ini.");
            }
            try
            {
                var builder = new ConfigurationBuilder();
                builder.AddIniFile(path);
                return builder.Build().Get<T>();
            }
            catch
            {
                return default(T);
            }
        }

        public static T GetConsul()
        {
            var path = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "Setting", "ConsulSetting.ini");
            if (!File.Exists(path))
            {
                return default(T);
            }
            try
            {
                var builder = new ConfigurationBuilder();
                builder.AddIniFile(path);
                return builder.Build().Get<T>();
            }
            catch
            {
                return default(T);
            }
        }

        public static T GetToolSetting()
        {
            var path = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "Setting", "ToolSetting.ini");
            if (!File.Exists(path))
            {
                return default(T);
            }
            try
            {
                var builder = new ConfigurationBuilder();
                builder.AddIniFile(path);
                return builder.Build().Get<T>();
            }
            catch
            {
                return default(T);
            }
        }
    }
}
