﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.DashboardRepository.Repositories.Interface;
using Siger.Middlelayer.Repository.Repositories.Interface;
using Siger.Middlelayer.Repository.Response;

// For more information on enabling Web API for empty projects, visit https://go.microsoft.com/fwlink/?LinkID=397860

namespace Siger.ApiDashboard.Controllers
{

    public class DashboardMachineGroupController : BaseController
    {
        private readonly IDashboardMachineGroupRepository _dashboardMachineGroup;
        private readonly ISigerProjectLevelSectionRepository _sigerProjectLevelSection;

        public DashboardMachineGroupController(IDashboardMachineGroupRepository dashboardMachineGroup, ISigerProjectLevelSectionRepository sigerProjectLevelSection)
        {
            this._dashboardMachineGroup = dashboardMachineGroup;
            this._sigerProjectLevelSection = sigerProjectLevelSection;
        }
        /// <summary>
        /// 获取自定义分组
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        public IActionResult GetMachineGroup()
        {
            var result = new List<ResponseMachineGroup>();
            var grouplst = _dashboardMachineGroup.GetList(f => f.projectid == ProjectId && f.status == (int)RowState.Valid);

            foreach (var group in grouplst)
            {
                var machineGrp = new ResponseMachineGroup
                {
                    GroupId = group.id,
                    Title = group.group,
                    Machines = new List<MachineGroup>()
                };
                //var machines = group.machineid.Split(',').Select(t => t.ToInt());
                //foreach (var m in machines)
                //{
                //    var machineSection = _sigerProjectLevelSection.Get(f => f.id == m);
                //    if (machineSection == null)
                //        continue;
                //    machineGrp.Machines.Add(new MachineGroup
                //    {
                //        machineId = machineSection.id,
                //        Title = machineSection.title
                //    });

                //}
                result.Add(machineGrp);
            }
            return new ObjectResult(result);
        }

    }
}