﻿using System;
using System.Collections.Generic;
using Microsoft.AspNetCore.Mvc;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.ModuleEnum;
using Siger.Middlelayer.Repository;
using Siger.Middlelayer.WmsRepository.Entities;
using Siger.Middlelayer.WmsRepository.Repositories.Interface;
using Siger.Middlelayer.WmsRepository.Request;

namespace Siger.ApiWMS.Controllers
{
    /// <summary>
    /// 系统设置
    /// </summary>
    public class SystemController : BaseController
    {
        private readonly object lockObj = new object();
        Isiger_wms_settingsRepository setting;
        Isiger_wms_idRepository idRepository;
        IUnitOfWork unitofwork;

        /// <summary>
        /// 
        /// </summary>
        /// <param name="setting"></param>
        /// <param name="idRepository"></param>
        /// <param name="unitofwork"></param>
        public SystemController(Isiger_wms_settingsRepository setting, Isiger_wms_idRepository idRepository, IUnitOfWork unitofwork)
        {
            this.setting = setting;
            this.idRepository = idRepository;
            this.unitofwork = unitofwork;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public IActionResult UpdateSettings() => throw new NotImplementedException();
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        public IActionResult GetSettings()
        {
            var result = new Dictionary<string, string>();
            AddDic(result, Settings.WaveHousingPre);
            AddDic(result, Settings.WaveHouseOutPre);
            AddDic(result, Settings.AllocationPre);
            AddDic(result, Settings.SystemBatchPre);
            AddDic(result, Settings.WaveHousingPrintBatch);
            AddDic(result, Settings.WaveHousingPrintBatchCount);
            AddDic(result, Settings.WaveHousingPrintNo);
            AddDic(result, Settings.WaveHousingPrintNoCount);
            AddDic(result, Settings.WaveHouseOutPrintBatch);
            AddDic(result, Settings.WaveHouseOutBatchCount);

            return new ObjectResult(result);
        }
        /// <summary>
        /// 获取单据号
        /// </summary>
        /// <param name="data"></param>
        /// <returns></returns>
        public IActionResult GetBillID(Settings data)
        {
            return new ObjectResult(setting.GetBillIDs(data, ProjectId));
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="req"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult Set([FromBody]RequestAddSetting req)
        {
            //check value
            foreach (var item in req.datas)
            {
                switch (item.data)
                {
                    case Settings.WaveHousingPre:
                    case Settings.WaveHouseOutPre:
                    case Settings.AllocationPre:
                    case Settings.SystemBatchPre:
                    case Settings.CheckPre:
                        break;

                    case Settings.WaveHousingPrintBatch:
                    case Settings.WaveHousingPrintNo:
                    case Settings.WaveHouseOutPrintBatch:
                        if (item.value != "0" && item.value != "1")
                        {
                            throw new BadRequestException(RequestEnum.ValueError);
                        }
                        break;

                    case Settings.WaveHousingPrintBatchCount:
                    case Settings.WaveHousingPrintNoCount:
                    case Settings.WaveHouseOutBatchCount:
                        if (!int.TryParse(item.value, out int v))
                        {
                            throw new BadRequestException(RequestEnum.ValueError);
                        }
                        break;
                    default:
                        break;
                }
                var tmp = setting.Get(f => f.key == item.data.ToString() && f.projectid == ProjectId);
                if (tmp == null)
                {
                    setting.Insert(new siger_wms_settings
                    {
                        key = item.data.ToString(),
                        value = item.value.Trim(),
                        projectid = ProjectId
                    });
                }
                else
                {
                    tmp.value = item.value.Trim();
                    setting.Update(tmp);
                }
            }
            if (unitofwork.Commit() > 0)
            {
                return Ok();
            }
            throw new BadRequestException(CommonEnum.Fail);
        }
        private void AddDic(Dictionary<string, string> dic, Settings data)
        {
            var tmp = setting.Get(f => f.key == data.ToString() && f.projectid == ProjectId);
            if (tmp == null)
            {
                string value = "";
                switch (data)
                {
                    case Settings.WaveHousingPre:
                        value = "SH";
                        break;
                    case Settings.WaveHouseOutPre:
                        value = "SC";
                        break;
                    case Settings.AllocationPre:
                        value = "SC";
                        break;
                    case Settings.SystemBatchPre:
                        value = "PC";
                        break;
                    case Settings.WaveHousingPrintBatch:
                        value = "0";
                        break;
                    case Settings.WaveHousingPrintBatchCount:
                        value = "1";
                        break;
                    case Settings.WaveHousingPrintNo:
                        value = "0";
                        break;
                    case Settings.WaveHousingPrintNoCount:
                        value = "1";
                        break;
                    case Settings.WaveHouseOutPrintBatch:
                        value = "0";
                        break;
                    case Settings.WaveHouseOutBatchCount:
                        value = "1";
                        break;
                    default:
                        break;
                }
                dic.Add(data.ToString(), value);
            }
            else
                dic.Add(data.ToString(), tmp.value);
        }

    }
}