﻿using Siger.Middlelayer.Utility.ExcelImport;
using System.Collections.Generic;

namespace Siger.Middlelayer.Utility.ImportEntities
{
    public class InspectionStandardTemplate : ImportBase
    {
        [ExcelColumn("产品编号*")]
        public string productcode { get; set; }

        [ExcelColumn("产品名称")]
        [DonnetCreate]
        [DonnetValidate]
        public string productname { get; set; }

        [ExcelColumn("检验位置*")]
        public string section { get; set; }

        [ExcelColumn("项次")]
        [DonnetCreate]
        [DonnetValidate]
        public int seq { get; set; }

        [ExcelColumn("是否送检")]
        public string isinpect { get; set; }

        [ExcelColumn("检验类型")]
        public string inpectcategories { get; set; }

        [ExcelColumn("检验项目*")]
        public string item { get; set; }

        [ExcelColumn("检验标准*")]
        public string standard { get; set; }

        [ExcelColumn("维护方式*(打钩=>1,填值=>2)")]
        public string value_type { get; set; }

        [ExcelColumn("值类型*(单值=>1,最大值最小值=>2)")]
        public string value_category { get; set; }

        [ExcelColumn("单位")]
        public string unit { get; set; }

        [ExcelColumn("最小值")]
        public string min_value { get; set; }

        [ExcelColumn("最大值")]
        public string max_value { get; set; }

        [ExcelColumn("极差")]
        public string range { get; set; }

        [ExcelColumn("触发安灯(0->否1->是)")]
        public string trigger_andon { get; set; }

        [ExcelColumn("控制下限")]
        public string lcl { get; set; }

        [ExcelColumn("控制上限")]
        public string ucl { get; set; }

        [ExcelColumn("不良类别*")]
        [DonnetCreate]
        [DonnetValidate]
        public string unhealthy_category { get; set; }

        [ExcelColumn("不良名称*")]
        [DonnetCreate]
        [DonnetValidate]
        public string unhealthy_name { get; set; }

        [ExcelColumn("不良代码*")]
        public string unhealthy_code { get; set; }

        [ExcelColumn("维护人")]
        [DonnetCreate]
        [DonnetValidate]
        public string update_mid { get; set; }

        [ExcelColumn("维护时间")]
        [DonnetCreate]
        [DonnetValidate]
        public string update_time { get; set; }

    }

    public class InspectionStandardTemplates : ImportBase
    {
        [ExcelColumn("产品编号*")]
        public string productcode { get; set; }

        [ExcelColumn("产品名称")]
        [DonnetCreate]
        [DonnetValidate]
        public string productname { get; set; }

        [ExcelColumn("检验位置*")]
        public string section { get; set; }

        [ExcelColumn("项次")]
        [DonnetCreate]
        [DonnetValidate]
        public int seq { get; set; }

        [ExcelColumn("是否送检")]
        public string isinpect { get; set; }

        [ExcelColumn("检验类型")]
        public string inpectcategories { get; set; }

        [ExcelColumn("检验项目*")]
        public string item { get; set; }

        [ExcelColumn("检验标准*")]
        public string standard { get; set; }

        [ExcelColumn("维护方式*(打钩=>1,填值=>2)")]
        public string value_type { get; set; }

        [ExcelColumn("值类型*(单值=>1,最大值最小值=>2)")]
        public string value_category { get; set; }

        [ExcelColumn("单位")]
        public string unit { get; set; }

        [ExcelColumn("最小值")]
        public string min_value { get; set; }

        [ExcelColumn("最大值")]
        public string max_value { get; set; }

        [ExcelColumn("极差")]
        public string range { get; set; }

        [ExcelColumn("触发安灯(0->否1->是)")]
        public string trigger_andon { get; set; }

        [ExcelColumn("控制下限")]
        public string lcl { get; set; }

        [ExcelColumn("控制上限")]
        public string ucl { get; set; }

        [ExcelColumn("不良类别*")]
        [DonnetCreate]
        [DonnetValidate]
        public string unhealthy_category { get; set; }

        [ExcelColumn("不良名称*")]
        [DonnetCreate]
        [DonnetValidate]
        public string unhealthy_name { get; set; }

        [ExcelColumn("不良代码*")]
        public string unhealthy_code { get; set; }

        [ExcelColumn("维护人")]
        [DonnetCreate]
        [DonnetValidate]
        public string update_mid { get; set; }

        [ExcelColumn("维护时间")]
        [DonnetCreate]
        [DonnetValidate]
        public string update_time { get; set; }
        [ExcelColumn("值选项")]
        [IsShow(1)]
        public string item1 { get; set; }
        [ExcelColumn("结果")]
        [IsShow(2)]
        public string item2 { get; set; }
        [ExcelColumn("值选项")]
        [IsShow(3)]
        public string item3 { get; set; }
        [ExcelColumn("结果")]
        [IsShow(4)]
        public string item4 { get; set; }
        [ExcelColumn("值选项")]
        [IsShow(5)]
        public string item5 { get; set; }
        [ExcelColumn("结果")]
        [IsShow(6)]
        public string item6 { get; set; }
        [ExcelColumn("值选项")]
        [IsShow(7)]
        public string item7 { get; set; }
        [ExcelColumn("结果")]
        [IsShow(8)]
        public string item8 { get; set; }
        [ExcelColumn("值选项")]
        [IsShow(9)]
        public string item9 { get; set; }
        [ExcelColumn("结果")]
        [IsShow(10)]
        public string item10 { get; set; }

    }


    public class InspectionStandardList : InspectionStandardTemplate
    {
        [ExcelColumn("序号")]
        [DonnetCreate]
        [DonnetValidate]
        public int No { get; set; }
    }

    public class InspectStandardLevelTemplate : ImportBase
    {
        [ExcelColumn("产品编号*")]
        public string productcode { get; set; }

        [ExcelColumn("产品名称")]
        [DonnetCreate]
        [DonnetValidate]
        public string productname { get; set; }


        [ExcelColumn("不良代码*")]
        public string unhealthy_code { get; set; }

        [ExcelColumn("项次*")]
        public int seq { get; set; }

        [ExcelColumn("是否送检*(1=>人工检验2=>送检检验)*")]
        public string isinpect { get; set; }

        [ExcelColumn("检验类型*")]
        public string inpectcategories { get; set; }

        [ExcelColumn("检验项目*")]
        public string item { get; set; }

        [ExcelColumn("检验标准*")]
        public string standard { get; set; }

        [ExcelColumn("维护方式*(打钩=>1,填值=>2,选择值=>3)*")]
        public string value_type { get; set; }

        [ExcelColumn("值类型*(单值=>1,最大值最小值=>2)*")]
        public string value_category { get; set; }

        [ExcelColumn("单位")]
        public string unit { get; set; }

        [ExcelColumn("最小值")]
        public string min_value { get; set; }

        [ExcelColumn("最大值")]
        public string max_value { get; set; }

        [ExcelColumn("极差")]
        public string range { get; set; }

        [ExcelColumn("触发安灯(0->否1->是)*")]
        public string trigger_andon { get; set; }

        [ExcelColumn("控制下限")]
        public string lcl { get; set; }

        [ExcelColumn("控制上限")]
        public string ucl { get; set; }

        [ExcelColumn("不良类别*")]
        [DonnetCreate]
        [DonnetValidate]
        public string unhealthy_category { get; set; }

        [ExcelColumn("不良名称*")]
        [DonnetCreate]
        [DonnetValidate]
        public string unhealthy_name { get; set; }

        [ExcelColumn("维护人")]
        [DonnetCreate]
        [DonnetValidate]
        public string update_mid { get; set; }

        [ExcelColumn("维护时间")]
        [DonnetCreate]
        [DonnetValidate]
        public string update_time { get; set; }

        [ExcelColumn("值选项")]
        public string option { get; set; }

        [ExcelColumn("结果(1、OK，2、NG)")]
        public string result { get; set; }
    }

    public class InspectionStandardLevelTemplate : InspectStandardLevelTemplate
    {
        [ExcelColumn("产线结构")]
        public List<string> sections { get; set; } = new List<string>();
    }

    public class InspectionStandards : InspectionStandardLevelTemplate
    {
        public int productid { get; set; }

        public int sectionid { get; set; }

        public int unhealthyid { get; set; }

        public string unhealthyname { get; set; }

        public string item_en { get; set; }
    }

    public class InspectStandardMaterialLevelTemplate : ImportBase
    {
        [ExcelColumn("物料编号*")]
        public string materialpn { get; set; }

        [ExcelColumn("物料名称")]
        [DonnetCreate]
        [DonnetValidate]
        public string materialname { get; set; }

        [ExcelColumn("项次*")]
        public int seq { get; set; }

        [ExcelColumn("检验项目类别*")]
        public string category { get; set; }

        [ExcelColumn("检验项目*")]
        public string item { get; set; }

        [ExcelColumn("检验标准*")]
        public string standard { get; set; }

        [ExcelColumn("维护方式*(打钩=>1,填值=>2)")]
        public string value_type { get; set; }

        [ExcelColumn("值类型*(单值=>1,最大值最小值=>2)")]
        public string value_category { get; set; }

        [ExcelColumn("单位")]
        public string unit { get; set; }

        [ExcelColumn("最小值")]
        public string min_value { get; set; }

        [ExcelColumn("最大值")]
        public string max_value { get; set; }

        [ExcelColumn("极差")]
        public string range { get; set; }

        [ExcelColumn("不良类别*")]
        [DonnetCreate]
        [DonnetValidate]
        public string unhealthy_category { get; set; }

        [ExcelColumn("不良名称*")]
        [DonnetCreate]
        [DonnetValidate]
        public string unhealthy_name { get; set; }

        [ExcelColumn("不良代码*")]
        public string unhealthy_code { get; set; }

        [ExcelColumn("维护人")]
        [DonnetCreate]
        [DonnetValidate]
        public string update_mid { get; set; }

        [ExcelColumn("维护时间")]
        [DonnetCreate]
        [DonnetValidate]
        public string update_time { get; set; }
    }

    public class InspectionStandardMaterialLevelTemplate : InspectStandardMaterialLevelTemplate
    {
        [ExcelColumn("产线结构")]
        public List<string> sections { get; set; } = new List<string>();
    }

    public class InspectionStandardMaterials : InspectionStandardMaterialLevelTemplate
    {
        public int materialid { get; set; }

        public int sectionid { get; set; }

        public int unhealthyid { get; set; }

        public string unhealthyname { get; set; }

        public int categoryid { get; set; }
    }

    public class InspectionStandardMaterialTemplate : ImportBase
    {
        [ExcelColumn("物料编号*")]
        public string materialpn { get; set; }

        [ExcelColumn("物料名称")]
        [DonnetCreate]
        [DonnetValidate]
        public string materialname { get; set; }

        [ExcelColumn("物料规格")]
        [DonnetCreate]
        [DonnetValidate]
        public string materialspec { get; set; }

        [ExcelColumn("检验位置*")]
        public string section { get; set; }

        [ExcelColumn("项次*")]
        public int seq { get; set; }

        [ExcelColumn("是否送检")]
        public string isinpect { get; set; }

        [ExcelColumn("检验类型*")]
        public string inpectcategories { get; set; }

        [ExcelColumn("检验项目类别*")]
        public string category { get; set; }

        [ExcelColumn("检验项目*")]
        public string item { get; set; }

        [ExcelColumn("检验标准*")]
        public string standard { get; set; }

        [ExcelColumn("维护方式*(打钩=>1,填值=>2)")]
        public string value_type { get; set; }

        [ExcelColumn("值类型*(单值=>1,最大值最小值=>2)")]
        public string value_category { get; set; }

        [ExcelColumn("单位")]
        public string unit { get; set; }

        [ExcelColumn("最小值")]
        public string min_value { get; set; }

        [ExcelColumn("最大值")]
        public string max_value { get; set; }

        [ExcelColumn("极差")]
        public string range { get; set; }

        [ExcelColumn("不良类别*")]
        [DonnetCreate]
        [DonnetValidate]
        public string unhealthy_category { get; set; }

        [ExcelColumn("不良名称*")]
        [DonnetCreate]
        [DonnetValidate]
        public string unhealthy_name { get; set; }

        [ExcelColumn("不良代码*")]
        public string unhealthy_code { get; set; }

        [ExcelColumn("维护人")]
        [DonnetCreate]
        [DonnetValidate]
        public string update_mid { get; set; }

        [ExcelColumn("维护时间")]
        [DonnetCreate]
        [DonnetValidate]
        public string update_time { get; set; }
    }

    public class InspectionStandardMaterialList : InspectionStandardMaterialTemplate
    {
        [ExcelColumn("序号")]
        [DonnetCreate]
        [DonnetValidate]
        public int No { get; set; }
    }
}
