﻿using Siger.Middlelayer.Utility.ExcelImport;

namespace Siger.Middlelayer.Utility.ImportEntities
{
    public class ProductStructureTemplate : ImportBase
    {
        [ExcelColumn("编号")]
        [EmptyValidate("serialnumberIsEmpty")]
        public string serial_number { get; set; }

        [ExcelColumn("品名")]
        public string name { get; set; }

        [ExcelColumn("规格")]
        public string spec { get; set; }

        [ExcelColumn("父料号")]
        public string parent_pn { get; set; }

        [ExcelColumn("料号")]
        public string pn { get; set; }

        /// <summary>
        /// 不用导入,根据料号获取
        /// </summary>
        [ExcelColumn("类别")]
        public string material_type_name { get; set; }

        [ExcelColumn("数量")]
        public string quantity { get; set; }

        [ExcelColumn("计量单位")]
        public string unit_id { get; set; }

        [ExcelColumn("备注")]
        public string desc { get; set; }
    }

    public class ProductStructureList : ProductStructureTemplate
    {
        [ExcelColumn("序号")]
        [DonnetValidate]
        [DonnetCreate]
        public int No { get; set; }
    }
}
