using Microsoft.Extensions.Configuration;
using Siger.CommonUtil;
using Siger.CommonUtil.UniformConfigExtend;
using Siger.DataSchedule.Infrastructure.Extend;
using Siger.DW.Demo.Business;
using System;
using System.IO;
using Xunit;

namespace Siger.DW.UnitTest
{
    public class DwDemo
    {
        static DwDemo()
        {
            IConfiguration config = new ConfigurationBuilder()
                .AddJsonFile(Path.Combine(AppDomain.CurrentDomain.BaseDirectory, @"appsettings.json"))
                .Build();
            var urlPath = config["UnifromUrl"];
            UniformConfigFactory.RegisterConfig(urlPath);
        }

        [Fact]
        public void SliceSateCommonBusiness()
        {
            IScheduleJob scheduleJob = new SliceSateCommonBusiness();

            ScheduleContext content = new ScheduleContext();
            content.Config = ConfigFactory.GetConfig();
            //
            var scheduleConfig = content.Config.GetSectionObj<ScheduleAllRuleConfig>("ScheduleAllConfig");
        }
    }
}
