﻿using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.Common.Configuration;
using Siger.Middlelayer.Repository.Entities;

namespace Siger.Middlelayer.AccRepository
{
    public class ApiAccDbContext : DbContext
    {
        public ApiAccDbContext()
        {

        }
        public ApiAccDbContext(DbContextOptions<ApiAccDbContext> options) : base(options)
        {

        }

        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {

        }

        protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder)
        {
            var useOneDb = ConfigManager.GetValue("DbSetting", "UseOneDb", true);
            if (useOneDb)
            {
                var mySqlConnection = ConfigManager.GetValue("DbSetting", "DbConnection", string.Empty);
                if (!string.IsNullOrEmpty(mySqlConnection))
                {
                    optionsBuilder.UseMySql(mySqlConnection);
                }
            }
            else
            {
                var clusterConnection = ConfigManager.GetValue("DbClusterSetting", "ClusterConnection", string.Empty);
                if (!string.IsNullOrEmpty(clusterConnection))
                {
                    optionsBuilder.UseMySql(clusterConnection);
                }
            }
        }
        public DbSet<SigerTrCategory> siger_tr_category { get; set; }
        public DbSet<SigerTrDict> siger_tr_dict { get; set; }
        public DbSet<SigerTrEquipment> siger_tr_equipment { get; set; }
        public DbSet<SigerTrEquipmentPosition> siger_tr_position_equipment { get; set; }
        public DbSet<SigerTrRoutingEventNo> siger_tr_routing_eventno { get; set; }
        public DbSet<SigerTrRoutingOutStation> siger_tr_routing_outstation { get; set; }
        public DbSet<SigerTrRoutingInStation> siger_tr_routing_instation { get; set; }
        public DbSet<SigerTrPackingFullQty> siger_tr_packing_fullqty { get; set; }
        public DbSet<SigerTrPrinterSetting> siger_tr_printer_setting { get; set; }
        public DbSet<SigerTrPrinterLebleFile> siger_tr_printer_labelfile { get; set; }
        public DbSet<SigerTrCheckItem> siger_tr_oqc_check_item { get; set; }
        public DbSet<SigerTrWOBookingItem> siger_tr_wo_booking_item { get; set; }
        public DbSet<SigerTrBaseSettingItem> siger_tr_station_base_setting_item { get; set; }
        public DbSet<SigerTrBaseSetting> siger_tr_station_base_setting { get; set; }

        public DbSet<SigerTrSnList> siger_tr_sn_list { get; set; }
        public DbSet<SigerTrPn> siger_tr_pn { get; set; }
        public DbSet<SigerTrSnTrace> siger_tr_sn_trace { get; set; }
        public DbSet<SigerTrCategoryItem> siger_tr_categoryitem { get; set; }
        public DbSet<SigerTrBatchTraceDetail> siger_tr_batch_trace_detail { get; set; }

        public DbSet<SigerTrLine> siger_tr_line { get; set; }
        public DbSet<SigerTrStation> siger_tr_station { get; set; }
        public DbSet<SigerTrPosition> siger_tr_position { get; set; }
        
        public DbSet<SigerTrAssemblyMaintenance> siger_tr_assembly_maintenance { get; set; }
        public DbSet<SigerTrWorkingOrder> siger_tr_working_order { get; set; }
        public DbSet<SigerTrWoMaterial> siger_tr_wo_material { get; set; }
        public DbSet<SigerTrReworkWoSetting> siger_tr_rework_wo_setting { get; set; }
        public DbSet<SigerTrReworkBindSerial> siger_tr_rework_bind_serial { get; set; }

        public DbSet<siger_project_level> siger_project_level { get; set; }
        public DbSet<siger_project_level_section> siger_project_level_section { get; set; }
        public DbSet<siger_project_product> siger_project_product { get; set; }
        public DbSet<siger_project_user> siger_project_user { get; set; }

        public DbSet<siger_project_machine_attribution> siger_project_machine_attribution { get; set; }
        public DbSet<siger_project_machine> siger_project_machine { get; set; }
        public DbSet<siger_user> siger_user { get; set; }
        public DbSet<siger_project_section> siger_project_section { get; set; }

        public DbSet<SigerTrBasketfType> siger_tr_basketful_type { get; set; }
        public DbSet<SigerTrBasketfSetting> siger_tr_basketful_setting { get; set; }
        public DbSet<SigerTrBasketlist> siger_tr_basketlist { get; set; }

        public DbSet<SigerTrProductReport> siger_tr_product_report { get; set; }
        public DbSet<siger_project_product_plan_detail> siger_project_product_plan_detail { get; set; }
        public DbSet<Entities.siger_project_product_plan> siger_project_product_plan { get; set; }
        public DbSet<SigerTrSerinumcfg> siger_tr_serinumCfg { get; set; }

        public DbSet<siger_wms_bussinese_contacts> siger_wms_bussinese_contacts { get; set; }

        public DbSet<siger_project> siger_project { get; set; }
        public DbSet<siger_tr_basketful_position> siger_tr_basketful_position { get; set; }
        public DbSet<SigerTrPackBoxSNList> siger_tr_pack_box_sn_list { get; set; }
        public DbSet<SigerTrReworkSnList> siger_tr_rework_sn_list { set; get; }
        public DbSet<SigerTrSNTraceDetail> siger_tr_sn_trace_detail { set; get; }
        public DbSet<SigerTrRoutingStaion> siger_tr_routing_staion { set; get; }
        public DbSet<SigerTrPackBoxList> siger_tr_pack_box_list { set; get; }
        public DbSet<SigerTrPageLevel> siger_tr_page_level { set; get; }
        public DbSet<SigerTrWaste> siger_tr_waste { set; get; }
        public DbSet<siger_tr_mould_position> siger_tr_mould_position { get; set; }
        public DbSet<SigerTrBlock> siger_tr_block { get; set; }
        public DbSet<SigerTrEmployStation> siger_tr_employ_station { get; set; }
        public DbSet<SigerTrClearData> siger_tr_clear_data { get; set; }
        public DbSet<SigerTrProduct> siger_tr_product { get; set; }
        public DbSet<SigerTrCarBoxSNList> siger_tr_car_box_sn_list { get; set; }
        public DbSet<SigerTrPowerSection> siger_tr_power_section { get; set; }
        public DbSet<SigerTrWHBoxList> siger_tr_wh_box_list { get; set; }
        public DbSet<SigerTrSectionMenu> siger_tr_section_menu { get; set; }
        public DbSet<SigerTrSnBasket> siger_tr_sn_basket { get; set; }
        public DbSet<SigerTrSnPart> siger_tr_sn_part { get; set; }
        public DbSet<siger_tr_materials> siger_tr_materials { get; set; }
        public DbSet<siger_tr_material_type> siger_tr_material_type { get; set; }

        public DbSet<siger_tr_basket_report_ttl> siger_tr_basket_report_ttl { get; set; }
        public DbSet<siger_tr_basket_check_ttl> siger_tr_basket_check_ttl { get; set; }
        public DbSet<SigerTrMenu> siger_tr_menu { get; set; }
        public DbSet<siger_project_process> siger_project_process { get; set; }
        public DbSet<siger_user_power> siger_user_power { get; set; }
        public DbSet<SigerTrSnTraceSummary> siger_tr_sn_trace_summary { get; set; }

        public DbSet<siger_project_shift> siger_project_shift { get; set; }
        public DbSet<siger_project_product_report> siger_project_product_report { get; set; }
        public DbSet<SigerTrRoutingStaionRptItem> siger_tr_routing_staion_rpt_item { set; get; }

        public DbSet<siger_project_produce_schedule> siger_project_produce_schedule { get; set; }
        public DbSet<siger_project_product_route> siger_project_product_route { get; set; }

        public DbSet<SigerTrParameterConfig> siger_tr_parameter_config { get; set; }
        public DbSet<siger_tr_package> siger_tr_package { get; set; }
        public DbSet<siger_tr_package_details> siger_tr_package_details { get; set; }
        public DbSet<siger_tr_assemb_details> siger_tr_assemb_details { get; set; }

        public DbSet<SigerTrProductStructure> siger_tr_product_structure { get; set; }

        public DbSet<siger_project_beat_set> siger_project_beat_set { get; set; }

        public DbSet<siger_qms_inspection_standard> siger_qms_inspection_standard { get; set; }

        public DbSet<siger_qms_inspection_standard_option> siger_qms_inspection_standard_option { get; set; }
        public DbSet<siger_tr_assist_materials> siger_tr_assist_materials { get; set; }
        public DbSet<siger_qms_type_count_setting> siger_qms_type_count_setting { get; set; }
        public DbSet<siger_project_usergroup> siger_project_usergroup { get; set; }
        public DbSet<siger_project_order_type> siger_project_order_type { get; set; }
        public DbSet<SigerTrPrinterRelation> siger_tr_printer_relation { get; set; }

        public DbSet<siger_automation_fixture_tools_category> siger_automation_fixture_tools_category { get; set; }
        public DbSet<siger_automation_fixture_tools_assembly> siger_automation_fixture_tools_assembly { get; set; }
        public DbSet<siger_automation_fixture_tools> siger_automation_fixture_tools { get; set; }
        public DbSet<siger_automation_fixture_tools_product> siger_automation_fixture_tools_product { get; set; }
        public DbSet<siger_automation_location> siger_automation_location { get; set; }
        public DbSet<siger_automation_section_property> siger_automation_section_property { get; set; }
        public DbSet<siger_automation_section_route> siger_automation_section_route { get; set; }
        public DbSet<siger_automation_task_list> siger_automation_task_list { get; set; }


        public DbSet<siger_wms_storage> siger_wms_storage { get; set; }
        public DbSet<siger_wms_storage_location> siger_wms_storage_location { get; set; }

        public DbSet<siger_automation_line_mode> siger_automation_line_mode { get; set; }
        public DbSet<siger_automation_machine_status> siger_automation_machine_status { get; set; }

        public DbSet<siger_automation_produce_history> siger_automation_produce_history { get; set; }

        public DbSet<siger_automation_fixture_tools_monitor> siger_automation_fixture_tools_moniter { get; set; }

        public DbSet<siger_check_sn_trace_inspection> siger_check_sn_trace_inspection { get; set; }
    }
}
