﻿using System.Collections.Generic;
using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Response;
using Siger.Middlelayer.Common.ModuleEnum;

namespace Siger.Middlelayer.AccRepository.Repositories.Interface
{
    public interface ISigerAccTraceRepository : IAccRepositoryBase<SigerTrSNTraceDetail>
    {
        ResponeBaseItem GetBaseSetting(int sectionId, int projectId);
        int GetCheckkInUser(int sectionId, int projectId);
        string SaveTraceAndUpdateStatus(string sn, int station, int uid, string resultstatus, EvenNoEnum eventNo = EvenNoEnum.OK);
        void SaveTrace(SigerTrSnTrace sigerTrSnTrace);
        void SaveTraceDetails(SigerTrSNTraceDetail traceDetails);
        void SaveSnlist(SigerTrSnList snlistObj);
        void UpdateSNList(SigerTrSnList sigerTrSnList);
        SigerTrSnList FindSn(string Sn, int projectId);
        SigerTrSnTrace FindSeq(int projectid, int station, string sn);
        int Getline(int section, int projectid);
        SigerTrClearData FindClearData(int line, int projectid);

        ResponseSnData GetSectionDataByMachine(string code, int pid);

        string GetLineStationData(int section, int pid);
        int GetTraceCountByResult(int pid, int uid, int section, EvenNoEnum results);
    }
}
