﻿using System.Collections.Generic;
using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Response;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Utility.ImportEntities;

namespace Siger.Middlelayer.AccRepository.Repositories.Interface
{
    public interface ISigerRoutingOutStation: IAccRepositoryBase<SigerTrRoutingOutStation>
    {
        CommonImportResult ImportRoutingOutStation(IEnumerable<RoutingOutStationTemplate> outstations, int projectid);
        SigerTrRoutingOutStation GetResultStatusBySection(int section, int pid);
        SigerTrRoutingOutStation GetSectionByResultStatus(string resultStatus, int pid);


        IPagedCollectionResult<ResponseRoutingOutStation> GetRoutingOutStationPage(int projectId,int line, int station, int eventno, string status, int page = 1, int pagesize = 10);

    }
}
