﻿using System;
using System.Collections.Generic;
using System.Linq;
using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Repositories.Interface;
using Siger.Middlelayer.AccRepository.Response;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.ModuleEnum;

namespace Siger.Middlelayer.AccRepository.Repositories
{
    internal class SIgerTrSnBasketRepository : AccRepositoryBase<SigerTrSnBasket>, ISIgerTrSnBasketRepository
    {
        private ApiAccDbContext accDbContext;

        public SIgerTrSnBasketRepository(ApiAccDbContext context) : base(context)
        {
            accDbContext = context;
        }

        /// <summary>
        /// 获取料筐标签信息
        /// </summary>
        /// <param name="basketNumber"></param>
        /// <param name="pid"></param>
        /// <returns></returns>
        public ResponseSnBasketInfo GetSnBasketInfo(string basketNumber, int pid)
        {
            var basketInfos = from bl in accDbContext.siger_tr_basketlist
                              join bp in accDbContext.siger_tr_basketful_position on bl.traceId equals bp.traceid
                              where 
                                    bl.number.Equals(basketNumber, StringComparison.OrdinalIgnoreCase) &&
                                    bl.projectId.Equals(bp.projectId) && bl.projectId.Equals(pid)
                              select new ResponseSnBasketInfo()
                              {
                                  BasketNumber = bl.number,
                                  Count = bl.count,
                                  ProductName = bp.productname,
                                  WorkOrder = bp.workcode,
                                  Model = bp.producttype,
                                  TraceId =bl.traceId,
                              };
            var response = basketInfos.FirstOrDefault();
            if (response == null)
            {
                return response;
            }

            //查询snbasket是否有已打标的信息
            var snInfos = accDbContext.siger_tr_sn_basket.Where(f =>
                f.BasketNumber.Equals(basketNumber) && f.status.Equals((int)RowState.Valid) &&
                f.projectId.Equals(pid)).OrderBy(o => o.Sn).Select(s => s.Sn).ToList();
            if (snInfos.Any())
            {
                response.CountIn = snInfos.Count();
                response.SnList = snInfos;
            }

            return response;
        }

        public List<SigerTrSnTrace> GetBasketTraceData(string basketNumber, int pid)
        {
            var basketReportList = from pr in accDbContext.siger_tr_product_report
                                   join bp in accDbContext.siger_tr_basketful_position on pr.TraceId equals bp.traceid
                                   where pr.Number.Equals(basketNumber) && pr.projectId.Equals(pid) &&
                                         pr.Type == (int)Type_Status.basket
                                   orderby pr.Time descending 
                                   select new
                                   {
                                       bp.position,
                                       bp.productbh,
                                       bp.workcode,
                                       pr.Time,
                                       pr.Uid
                                   };
            if (!basketReportList.Any())
            {
                throw new BadRequestException(CommonEnum.NoData);
            }
            var basketTraceList = new List<SigerTrSnTrace>();
            foreach (var basketData in basketReportList)
            {
                var basketTrace = new SigerTrSnTrace();
                basketTrace.SeqID = Guid.NewGuid().ToString();
                basketTrace.ProductID = basketData.productbh;
                basketTrace.Station = basketData.position;
                basketTrace.WO = basketData.workcode;
                basketTrace.TransDateTime = basketData.Time;
                basketTrace.LastUpdateTime = DateTime.Now;
                basketTrace.UID = basketData.Uid;
                basketTraceList.Add(basketTrace);
            }

            return basketTraceList;
        }
    }
}
