﻿using System.Linq;
using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Repositories.Interface;
using Siger.Middlelayer.AccRepository.Response;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.ModuleEnum;

namespace Siger.Middlelayer.AccRepository.Repositories
{
    internal class SigerTrSnPartRepository : AccRepositoryBase<SigerTrSnPart>, ISigerTrSnPartRepository
    {
        private ApiAccDbContext accDbContext;
        public SigerTrSnPartRepository(ApiAccDbContext context) : base(context)
        {
            accDbContext = context;
        }

        public siger_project_product_plan_detail GetWoData(string workOrder, int pid)
        {
            var orderNumber =
                accDbContext.siger_project_product_plan_detail.FirstOrDefault(f =>
                    f.projectId.Equals(pid) && f.OrderNumber.Equals(workOrder));
            if (orderNumber == null)
            {
                throw new BadRequestException(AccEnum.Data_Null);
            }
            return orderNumber;
        }

        public IQueryable<ResponseSnPartInfo> GetSnData(string sn, int pid)
        {
            var snData = from s in accDbContext.siger_tr_sn_list
                         join p in accDbContext.siger_project_product on s.ProductCode equals p.code
                         where s.SN.Equals(sn) && s.projectId.Equals(pid) && p.status == (int)RowState.Valid
                         select new ResponseSnPartInfo()
                         {
                             Sn = s.SN,
                             ProductName = p.name
                         };
            return snData;
        }
    }
}
