﻿using System;
using System.Linq;
using System.Linq.Expressions;
using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Repositories.Interface;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Repository.Data;
using Siger.Middlelayer.Repository.Paged;

namespace Siger.Middlelayer.AccRepository.Repositories
{
    internal class SigerTrWoMaterialRepository : AccRepositoryBase<SigerTrWoMaterial>, ISigerTrWoMaterialRepository
    {
        private readonly ApiAccDbContext accDbContext;
        public SigerTrWoMaterialRepository(ApiAccDbContext context) : base(context)
        {
            accDbContext = context;
        }

        public IPagedCollectionResult<WoMaterial> GetPagedList(string wo, int projectid, int page, int pagesize)
        {
            int rowstate = (int)RowState.Valid;
            var woMaterials =
                accDbContext.siger_tr_wo_material.Where(q => q.status == (int)RowState.Valid && q.projectId == projectid);
            var query = from p in woMaterials
                        join m in accDbContext.siger_tr_materials
                        on p.pn equals m.pn into mtemp
                        from m in mtemp.DefaultIfEmpty()
                        join q in accDbContext.siger_tr_material_type
                        on m.typeid equals q.id
                        into temp
                        from q in temp.DefaultIfEmpty()
                        join d in accDbContext.siger_tr_dict
                        on new { unitdict = p.unit, rowstatus = rowstate, cats = AccDictCost.meterunits, projectids = projectid }
                        equals new { unitdict = d.dkey, rowstatus = d.status, cats = d.cat, projectids = d.projectId }
                        into dtemp
                        from d in dtemp.DefaultIfEmpty()
                        where m.projectId == projectid && m.status == (int)RowState.Valid
                        select new WoMaterial
                        {
                            id = p.id,
                            wo = p.wo,
                            materials_id = m.id,
                            name = m.name ?? "",
                            spec = m.spec ?? "",
                            pn = p.pn,
                            quntity = p.quantity,
                            unit = p.unit ?? "",
                            unit_value = d.dval ?? "",
                            material_type_id = m.typeid > 0 ? m.typeid : 0,
                            material_type_id_value = q.name ?? "",
                            desc = m.desc ?? ""
                        };
            Expression<Func<WoMaterial, bool>> predicate = f => true;
            if (!string.IsNullOrEmpty(wo) && wo !="0")
                predicate = f => f.wo == wo;

            var totalCount = query.Count(predicate);
            var entities = query.Where(predicate).OrderByDescending(q => q.id).Skip((page - 1) * pagesize).Take(pagesize).AsNoTracking().ToList();
            return new PagedCollectionResult<WoMaterial>(entities, totalCount);
        }
    }
}
