﻿using System.Collections.Generic;
using Siger.Middlelayer.CncRepository.Entities;
using Siger.Middlelayer.CncRepository.Response;
using Siger.Middlelayer.Repository.Paged;

namespace Siger.Middlelayer.CncRepository.Repositories.Interface
{
    public interface IMachineCurrentStateRepository : ICncRepositoryBase<siger_project_working_machine_current_state>
    {
        IEnumerable<ResponseMachineBeatAnalysis> GetMachineBeatAnalysis(int levelId, string timerange, int workgroupId,
            int userId, int projectId);

        IPagedCollectionResult<ResponseMachineStateRecord> GetPagedCollectionResult(string timerange, int sectionId,
            int workgroupId, int userId,
            int projectId, int state = 0, int page = 1, int pagesize = 10, int toexcel = 0);

        IEnumerable<siger_project_working_machine_current_state> GetCurrentStates(IEnumerable<int> machineids,
            string timerange, IEnumerable<int> userIds, int state, int projectId);
    }
}
