﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.CncRepository.Entities;
using Siger.Middlelayer.CncRepository.Repositories.Interface;
using Siger.Middlelayer.CncRepository.Response;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Repository.Data;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Repository.Response;
using Siger.Middlelayer.Share.Models;

namespace Siger.Middlelayer.CncRepository.Repositories
{
    internal class MachineParamAlarmRepository : CncRepositoryBase<siger_project_machine_param_alarm>, IMachineParamAlarmRepository
    {
        private readonly ApiCncDbContext _context;
        public MachineParamAlarmRepository(ApiCncDbContext context) : base(context)
        {
            _context = context;
        }

        public MachineState GetMachine(machinesLists item, ResponseGetStatus result, int projectId)
        {
            var machine = _context.siger_project_cj_machine.Where(q => q.machineId.Equals(item.machineId) && q.projectid==projectId).Select(q => q.mid).FirstOrDefault();
            var query = from a in _context.siger_project_machine_attribution
                        join b in _context.siger_project_level_section on a.station equals b.id
                        where a.machine == machine && a.status == (int)RowState.Valid
                        select new MachineState
                        {
                            machineTitle = b.title,
                            MachineId = machine,
                            section_id=b.id,
                            Staus = item.runStatus == 0 ? 3 : (item.runStatus == 1 ? 1 : (item.runStatus == 2 ? 2 : (item.runStatus == 3 ? 4 : (item.runStatus == 4 ? 0 : item.runStatus))))
                        };
            var itemList = query.FirstOrDefault();
            if (itemList!=null)
            {
                itemList.machinestatus = new List<MachineStatusSummarys>();
                foreach (var mac in result.data.ToList())
                {
                    var list = new MachineStatusSummarys();

                    list.time = mac.duration;
                    list.status = mac.status == 0 ? 3 : (mac.status == 1 ? 1 : (mac.status == 2 ? 2 : (mac.status == 3 ? 4 : (mac.status == 4 ? 0 : mac.status))));
                    itemList.machinestatus.Add(list);
                }
                return itemList;
            }
            else
            {
                return null;
            }
        }

        public List<int> GetMachineIds(List<ResponseGetLevelTwo> sectionids, int projectId)
        {
            var query = from a in _context.siger_project_machine_attribution
                        join b in _context.siger_project_cj_machine on a.machine equals b.mid
                        where a.projectid == projectId && a.status == (int)RowState.Valid && b.projectid == projectId && b.status == (int)RowState.Valid
                        select new MachineIdList 
                        { 
                            section_id=a.station,
                            MachineId=a.machine
                        };
            var list = new List<int>();
            foreach (var item in query)
            {
                var mid = sectionids.Where(q => q.section_id == item.section_id).ToList();
                if (mid!=null&&mid.Count>0)
                {
                    list.Add(item.MachineId);
                }
            }
            return list;
        }

        public MachineState GetMachines(int machineid,int projectId)
        {
            var query = from a in _context.siger_project_machine_attribution
                        join b in _context.siger_project_level_section on a.station equals b.id
                        where a.machine== machineid && a.status == (int)RowState.Valid
                        select new MachineState
                        {
                            machineTitle = b.title,
                            MachineId = machineid,
                            section_id = b.id,
                            Staus = machineid == 2082 ? 0 : 1
                        };
            var itemList = new MachineState();
            foreach (var item in query)
            {
                itemList = item;
                itemList.machinestatus = new List<MachineStatusSummarys>();
                if (itemList.MachineId == 2082)
                {
                    var list = new MachineStatusSummarys();

                    list.time = 1200;
                    list.status = 0;
                    itemList.machinestatus.Add(list);
                }
                else if (itemList.MachineId == 2087)
                {
                    var list = new MachineStatusSummarys();

                    list.time = 1200;
                    list.status = 1;
                    itemList.machinestatus.Add(list);
                }
            }
            return itemList;
        }

        public IPagedCollectionResult<MachineParamAlarm> GetPagedParamAlarm(int sectionId, int projectId, int page,
            int pagesize)
        {
            var queryList = from q in _context.siger_project_machine_param_alarm
                join m in _context.siger_project_machine on q.machine_id equals m.id 
                where q.project_id == projectId && q.status == (int) RowState.Valid 
                                                && m.status == (int)RowState.Valid 
                select new MachineParamAlarm
                {
                    id = q.id,
                    project_id = q.project_id,
                    axis_rate_low = q.axis_rate_low,
                    axis_rate_top = q.axis_rate_top,
                    axis_speed_low = q.axis_speed_low,
                    axis_speed_top = q.axis_speed_top,
                    feed_amount_low = q.feed_amount_low,
                    feed_amount_top = q.feed_amount_top,
                    feed_rate_low = q.feed_rate_low,
                    feed_rate_top = q.feed_rate_top,
                    machine_id = q.machine_id,
                    machine_title = m.title
                };

            Expression<Func<MachineParamAlarm, bool>> sectionExpression = q => true;
            if (sectionId != 0)
            {
                var machineIds = GetLevelSectionMachineIds(sectionId, projectId);
                queryList = queryList.Where(q => machineIds.Contains(q.machine_id));
            }
            var totalCount = queryList.Count(sectionExpression);
            var entities = queryList.Where(sectionExpression).Skip((page - 1) * pagesize).Take(pagesize).AsNoTracking().ToList();

            return new PagedCollectionResult<MachineParamAlarm>(entities, totalCount);
        }
    }
}
