﻿using Microsoft.AspNetCore.Mvc;
using Siger.Middlelayer.Repository.Paged;
using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.Middlelayer.CncRepository.Response
{
    /// <summary>
    /// 质量合格率查询值和回参
    /// </summary>
    public class QualificationRate
    {
        /// <summary>
        /// 报工id
        /// </summary>
        public int report_id { get; set; }
        /// <summary>
        /// 产品名称
        /// </summary>
        public string product_name { get; set; }
        /// <summary>
        /// 工序名称
        /// </summary>
        public string route_name { get; set; }
        /// <summary>
        /// 设备位置
        /// </summary>
        public string machinelocal { get; set; }
        /// <summary>
        /// 班组名
        /// </summary>
        public string name { get; set; }
        public int uid { get; set; }
        /// <summary>
        /// 生产执行人唯一标识
        /// </summary>
        public string worker_code { get; set; }
        /// <summary>
        /// 生产执行人姓名
        /// </summary>
        public string worker_name { get; set; }
        /// <summary>
        /// 工令号
        /// </summary>
        public string code { get; set; }
        /// <summary>
        ///  ok——number
        /// </summary>
        public int actual_output { get; set; }
        /// <summary>
        /// nok_number
        /// </summary>
        public int nok_number { get; set; }
        /// <summary>
        ///  报工时间
        /// </summary>
        public int time { get; set; }
        /// <summary>
        /// 工位名称
        /// </summary>
        public string station_name { get; set; }
        /// <summary>
        ///  工位唯一标识
        /// </summary>
        public int station_id { get; set; }
        /// <summary>
        /// 设备
        /// </summary>
        public int machineid { get; set; }
        /// <summary>
        /// 日期
        /// </summary>
        public int day { get; set; }
    }

    /// <summary>
    /// 质量合格率统计返回值
    /// </summary>
    public class ResponseQualificationRate
    {
        /// <summary>
        /// x坐标值--时间范围每天
        /// </summary>
        public List<xdata> xdata { get; set; }
        /// <summary>
        /// y坐标值--工位或人员
        /// </summary>
        public List<ydata> ydata { get; set; }
        public ResponseQualificationRate()
        {
            xdata = new List<xdata>();
            ydata = new List<ydata>();
        }
    }

    public class xdata
    {
        /// <summary>
        /// 工位/人员title
        /// </summary>
        public string title { get; set; }
        /// <summary>
        /// 天数
        /// </summary>
        public string key { get; set; }
    }
    public class ydata
    {
        /// <summary>
        /// 工位或人员的唯一标识
        /// </summary>
        public int stationpersonid { get; set; }
        /// <summary>
        /// 工位或人员的名称
        /// </summary>
        public string stationperson { get; set; }
        /// <summary>
        /// 单条每天的百分比
        /// </summary>
        public List<ydatadetails> day { get; set; }
        public ydata()
        {
            day = new List<ydatadetails>();
        }
    }
    public class ydatadetails
    {
        /// <summary>
        /// 天数键
        /// </summary>
        public string key { get; set; }
        /// <summary>
        /// 效率百分比
        /// </summary>
        public double percent { get; set; } = 0;
    }

    /// <summary>
    /// 计划执行分析回参
    /// </summary>
    public class ResponsePlanExecutionAnalysis
    {
        /// <summary>
        /// plan表id
        /// </summary>
        public int id { get; set; }
        /// <summary>
        /// 工单号
        /// </summary>
        public string code { get; set; }
        /// <summary>
        /// 产品id
        /// </summary>
        public int product_id { get; set; }
        /// <summary>
        /// 产品名称
        /// </summary>
        public string product_name { get; set; }
        /// <summary>
        /// 计划生产数量
        /// </summary>
        public int plan_number { get; set; }
        /// <summary>
        /// 实际完成数量
        /// </summary>
        public int actual_number { get; set; }
        /// <summary>
        /// 交付时间
        /// </summary>
        public int delivery_time { get; set; }
        /// <summary>
        /// ok_number
        /// </summary>
        public int ok_number { get; set; }
        /// <summary>
        /// nok_number
        /// </summary>
        public int nok_number { get; set; }
        /// <summary>
        /// 合格率
        /// </summary>
        public double pass_rate { get; set; }
        /// <summary>
        /// 设备
        /// </summary>
        public int machineid { get; set; }
        /// <summary>
        /// 实际完成时间
        /// </summary>
        public int actual_completiontime { get; set; }
        /// <summary>
        /// 订单状态
        /// </summary>
        public int status { get; set; }
    }

    /// <summary>
    /// 计划执行分析数量汇总回参
    /// </summary>
    public class ResponsePlanSum 
    {
        /// <summary>
        /// 计划生产数量
        /// </summary>
        public int plannumber { get; set; }
        /// <summary>
        /// 实际生产数量
        /// </summary>
        public double actualnumber { get; set; }
        /// <summary>
        /// 总工单数量
        /// </summary>
        public int total { get; set; }
        /// <summary>
        /// 产量达成率
        /// </summary>
        public double productpercent { get; set; }
        /// <summary>
        /// 计划达成率
        /// </summary>
        public double planpercent { get; set; }
        /// <summary>
        /// 质量达成率
        /// </summary>
        public double qualitypercent { get; set; }
    }

}
