﻿using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.Common.Configuration;
using Siger.Middlelayer.DashboardRepository.Entities;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.TpmRepository.Entities;
using siger_project_dashboard_machine_group = Siger.Middlelayer.DashboardRepository.Entities.siger_project_dashboard_machine_group;
namespace Siger.Middlelayer.DashboardRepository
{
    public class ApiDashboardDbContext : DbContext
    {
        public ApiDashboardDbContext()
        {

        }
        public ApiDashboardDbContext(DbContextOptions<ApiDashboardDbContext> options) : base(options)
        {

        }
        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {

        }
        protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder)
        {
            var useOneDb = ConfigManager.GetValue("DbSetting", "UseOneDb", true);
            if (useOneDb)
            {
                var mySqlConnection = ConfigManager.GetValue("DbSetting", "DbConnection", string.Empty);
                if (!string.IsNullOrEmpty(mySqlConnection))
                {
                    optionsBuilder.UseMySql(mySqlConnection);
                }
            }
            else
            {
                var clusterConnection = ConfigManager.GetValue("DbClusterSetting", "ClusterConnection", string.Empty);
                if (!string.IsNullOrEmpty(clusterConnection))
                {
                    optionsBuilder.UseMySql(clusterConnection);
                }
            }
        }

        public DbSet<siger_dashboard_cn_set> siger_dashboard_cn_set { get; set; }

        public DbSet<siger_dashboard_cn_summary> siger_dashboard_cn_summary { get; set; }
        public DbSet<siger_dashboard_level_config> siger_dashboard_level_config { get; set; }
        public DbSet<siger_dashboard_factory_chanel> siger_dashboard_factory_chanel { get; set; }
        public DbSet<siger_project_level_section> siger_project_level_section { get; set; }
        public DbSet<siger_project_product> siger_project_product { get; set; }
        public DbSet<siger_project_product_route> siger_project_product_route { get; set; }
        public DbSet<siger_andon_station_config> siger_andon_station_config { get; set; }
        public DbSet<siger_project_machine_attribution> siger_project_machine_attribution { get; set; }
        public DbSet<siger_andon_expection_type> siger_andon_expection_type { get; set; }
        public DbSet<siger_andon_info> siger_andon_info { get; set; }
        public DbSet<siger_project_auto_calculation_data_ttl> siger_project_auto_calculation_data_ttl { get; set; }
        public DbSet<siger_project_level> siger_project_level { get; set; }
        public DbSet<siger_project_level_section_machine> siger_project_level_section_machine { get; set; }
        public DbSet<siger_project_machine> siger_project_machine { get; set; }

        public DbSet<siger_dashboard_total_set> siger_dashboard_total_set { get; set; }
        public DbSet<siger_project_auto_calculation_data_hour_ttl> siger_project_auto_calculation_data_hour_ttl { get; set; }
        public DbSet<siger_project_dashboard_machine_group> siger_project_dashboard_machine_group { get; set; }

        public DbSet<siger_project_dashboard_comb_page> siger_project_dashboard_comb_page { get; set; }

        public DbSet<siger_project_dashboard_page> siger_project_dashboard_page { get; set; }

        public DbSet<siger_project_dashboard_page_patial> siger_project_dashboard_page_patial { get; set; }

        public DbSet<siger_project_dashboard_page_patial_condition> siger_project_dashboard_page_patial_condition { get; set; }

        public DbSet<siger_project_dashboard_comb_page_condition> siger_project_dashboard_comb_page_condition { get; set; }

        public DbSet<siger_project_dashboard_comb> siger_project_dashboard_comb { get; set; }

        public DbSet<SigerTrDict> siger_tr_dict { get; set; }

        public DbSet<siger_project_dashboard_fixpath> siger_project_dashboard_fixpath { get; set; }
        public DbSet<siger_tr_saas_monitor> siger_tr_saas_monitor { get; set; }
        public DbSet<siger_tr_cjrf_device_real_time_status> siger_tr_cjrf_device_real_time_status { get; set; }
        public DbSet<siger_tr_cjrf_device_status_distribute_data> siger_tr_cjrf_device_status_distribute_data { get; set; }
        public DbSet<siger_tr_cjrf_device_status_summary_data> siger_tr_cjrf_device_status_summary_data { get; set; }
        public DbSet<siger_tr_cjrf_realtime_alarm> siger_tr_cjrf_realtime_alarm { get; set; }
        public DbSet<siger_tr_cjrf_time_efficiency> siger_tr_cjrf_time_efficiency { get; set; }
        public DbSet<siger_tr_cjrf_time_efficiency_top10> siger_tr_cjrf_time_efficiency_top10 { get; set; }
        public DbSet<siger_tr_cjrf_today_alarm_top5> siger_tr_cjrf_today_alarm_top5 { get; set; }

    }
}
