﻿using System.Collections.Generic;
using System.Linq;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.FieldEnum;
using Siger.Middlelayer.EsopRepository.Entities;
using Siger.Middlelayer.EsopRepository.Repositories.Interface;
using Siger.Middlelayer.EsopRepository.Response;

namespace Siger.Middlelayer.EsopRepository.Repositories
{
    internal class EsopDocumentHistoryRepository : EsopRepositoryBase<siger_project_esop_document_history>, IEsopDocumentHistoryRepository
    {
        private readonly ApiEsopDbContext _context;
        public EsopDocumentHistoryRepository(ApiEsopDbContext context) : base(context)
        {
            _context = context;
        }

        public IEnumerable<ResponseGetDocumentHistoryList> GetDocumentHistoryLists(int docId)
        {
            var query = from q in _context.siger_project_esop_document_history
                        join u in _context.siger_project_user on q.updator_mid equals u.mid
                        where q.document_id == docId
                        select new ResponseGetDocumentHistoryList
                        {
                            id = q.id,
                            creator_name = u.name,
                            datetime = q.update_time.ToString("yyyy-MM-dd"),
                            file_url = q.file_url,
                            is_valid = q.is_valid,
                            version = "V" + q.version,
                            version_name = q.version_name
                        };
            return query.AsEnumerable();
        }

        public IEnumerable<ResponseGetDocumentHistoryFileList> GetDocumentHistoryFileList(int machineId, int projectId)
        {
            var query = from q in _context.siger_project_esop_document_history
                        join d in _context.siger_project_esop_document on q.document_id equals d.id
                        where d.machine_id == machineId && q.is_valid == 1 && q.status == (int)RowState.Valid
                            && d.project_id == projectId && d.status == (int)RowState.Valid && d.approval_status == DocumentApprovalStatus.ApprovalPass
                        select new ResponseGetDocumentHistoryFileList
                        {
                            id = q.id,
                            document_id = d.id,
                            file_url = q.file_url,
                            file_name = q.file_name,
                            createtime = q.update_time.ToString(ParameterConstant.DateTimeFormat)
                        };
            return query.AsEnumerable();
        }
        /// <summary>
        /// 更新传感器文件名称
        /// </summary>
        /// <param name="projectid"></param>
        /// <param name="oldfile"></param>
        /// <param name="newfile"></param>
        public void UpdateSensorFile(int projectid, string oldfile, string newfile)
        {
            var models = _context.siger_qms_sensor_parameter.Where(f => f.bind_manual == oldfile).ToList();
            foreach (var item in models)
            {
                item.bind_manual = newfile;
            }
            _context.siger_qms_sensor_parameter.UpdateRange(models);
            models = _context.siger_qms_sensor_parameter.Where(f => f.validation_manual == oldfile).ToList();
            foreach (var item in models)
            {
                item.validation_manual = newfile;
            }
            _context.siger_qms_sensor_parameter.UpdateRange(models);
            models = _context.siger_qms_sensor_parameter.Where(f => f.standard_procedure1 == oldfile).ToList();
            foreach (var item in models)
            {
                item.standard_procedure1 = newfile;
            }
            _context.siger_qms_sensor_parameter.UpdateRange(models);
            models = _context.siger_qms_sensor_parameter.Where(f => f.standard_procedure2 == oldfile).ToList();
            foreach (var item in models)
            {
                item.standard_procedure2 = newfile;
            }
            _context.siger_qms_sensor_parameter.UpdateRange(models);
            _context.SaveChanges();
        }
    }
}
