﻿using System.Collections.Generic;
using System.Linq;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Repository.Response;
using Siger.Middlelayer.IMSRepository.Entities;
using Siger.Middlelayer.IMSRepository.Repositories.Interface;

namespace Siger.Middlelayer.IMSRepository.Repositories
{
    internal class ToollifeStoragePlatformRepository : IMSRepositoryBase<siger_project_ims_storage_platform>, IToollifeStoragePlatformRepository
    {
        private readonly ApiIMSDbContext _context;
        public ToollifeStoragePlatformRepository(ApiIMSDbContext context) : base(context)
        {
            _context = context;
        }

        public IEnumerable<ResponseKeyValue> GetAllMeterials(int projectId)
        {
            var query = _context.siger_tr_materials.Where(q =>
                    q.projectId == projectId && q.status == (int) RowState.Valid).OrderBy(m => m.name)
                .Select(m => new ResponseKeyValue(m.pn, m.name));

            return query.AsEnumerable();
        }

        public IEnumerable<ResponseKeyValue> GetAllSuppilers(int projectId)
        {
            var query = _context.siger_wms_bussinese_contacts.Where(q =>
                q.projectid == projectId && q.status == (int) RowState.Valid
                                         && q.supply_type == 1).OrderBy(m => m.name)
                .Select(m => new ResponseKeyValue(m.serial_number, m.name));

            return query.AsEnumerable();
        }
    }
}
