﻿using System.Collections.Generic;

namespace Siger.Middlelayer.IMSRepository.Request
{
    public class RequestAddChoice
    {
        public string workorder_code { get; set; }

        public string product_id { get; set; }
        public string id { get; set; }

        public string route { get; set; }
        public string machine_type { get; set; }
        public IEnumerable<SubmitChoice> paras { get; set; }
    }

    public class SubmitChoice
    {
        public string cutter_number { get; set; }

        public string part_no { get; set; }
        /// <summary>
        /// 仓库编号
        /// </summary>
        public string no { get; set; }

        /// <summary>
        /// 数量
        /// </summary>
        public int count { get; set; }
    }

    public class RequestToolOutStock
    {
        public string workorder_code { get; set; }

        public string product_id { get; set; }

        public string route { get; set; }
    }

    public class RequestToolInStock : RequestToolOutStock
    {
        public int storage_id { get; set; }
    }

    public class RequestEditSummary
    {
        public string product_id { get; set; }

        public string route { get; set; }

        public string workorder_code { get; set; }

        public List<EditSummary> Summarys { get; set; }
    }

    public class EditSummary
    {
        public string cutter_number { get; set; }

        public string part_no { get; set; }

        public string quantity { get; set; }

    }
}
