﻿using Siger.Middlelayer.Common.Extensions;
using Siger.Middlelayer.KpiRespository.Entities;
using Siger.Middlelayer.KpiRespository.Repositories.Interface;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
namespace Siger.Middlelayer.KpiRespository.Repositories
{
    internal class SigerKpiAuthorityRepostory : KpiRepositoryBase<siger_project_kpi_authority>, ISigerKpiAuthority
    {
        private ApiKpiDbContext kpiDbContext;
        public SigerKpiAuthorityRepostory(ApiKpiDbContext context) : base(context)
        {
            kpiDbContext = context;
        }

        public bool VerifyPermission(int mid, int section)
        {
            var userObj = kpiDbContext.siger_project_user.FirstOrDefault(f => f.mid == mid);
            if (userObj == null)
                return false;
            var permission = kpiDbContext.siger_project_kpi_authority.Where(f => f.usergroup == userObj.usergroupid.ToInt() && f.authorization==section);
            if (permission.Any())
                return true;
            else
                return false;
        }
    }
}
