﻿using Siger.Middlelayer.Share.ModuleEnum;
using System;
using System.Collections.Generic;
using System.Text;
using System.ComponentModel.DataAnnotations;
namespace Siger.Middlelayer.KpiRespository.Request
{
    public class RequestKpiitem
    {
        public int Section { get; set; }
        /// <summary>
        /// kpi 指标
        /// </summary>
        [Required(ErrorMessage ="ItemIsEmty")]
        public string Item { get; set; }
        public int ParentId { get; set; }
        /// <summary>
        /// 条件
        /// </summary>
        public int Condition { get; set; }
       
        /// <summary>
        /// 单位
        /// </summary>
        [Required(ErrorMessage = "UniIsEmty")]
        public string Unit { get; set; }
        /// <summary>
        /// 大屏位置
        /// </summary>
        public int Position { get; set; }
        /// <summary>
        ///  大屏背景
        /// </summary>
        public string BackColor { get; set; }
        public int  Enable { get; set; }

        public List<RequestCycleItem> Cycle { get; set; }

    }
    public class RequestCycleName
    {
       public int section { get; set; }
       public string itemName { get; set; }
    }
    public class RequestCycleItem
    {
        public KpiCycleEnum KpiCycle { get; set; }
        public double TargetVal { get; set; }
    }
    public class RequestModifyKpiitem
    {
        public int Id { get; set; }
        public int Section { get; set; }
        public KpiCycleEnum KpiCycle { get; set; }
        public string Item { get; set; }
        public int ParentId { get; set; }
        public int Condition { get; set; }
        public double TargetVal { get; set; }
        public string Unit { get; set; }
        /// <summary>
        /// 大屏位置
        /// </summary>
        public int Position { get; set; }
        /// <summary>
        ///  大屏背景
        /// </summary>
        public string BackColor { get; set; }
        public int Enable { get; set; }
    }
    public class KpiItemsObj
    {
        /// <summary>
        /// layout setting.ID
        /// </summary>
        public int Id { get; set; }
        /// <summary>
        /// kpi item id
        /// </summary>
        public int ItemId { get; set; }
        /// <summary>
        /// 0 部门
        /// </summary>
        public int Section { get; set; }
        /// <summary>
        /// 大屏位置
        /// </summary>
        public int Position { get; set; }
        /// <summary>
        ///  大屏背景
        /// </summary>
        public string BackColor { get; set; }
        public int Layout { get; set; }
    }
}
