﻿using System.Collections.Generic;
using System.Linq;
using System.Text.RegularExpressions;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.QmsRepository.Entities;
using Siger.Middlelayer.QmsRepository.Repositories.Interface;
using Siger.Middlelayer.Utility.ImportEntities;

namespace Siger.Middlelayer.QmsRepository.Repositories
{
    internal class InspectUnhealthyRepository : QMSRepositoryBase<siger_qms_inspection_unhealthy>, IInspectUnhealthyRepository
    {
        private readonly ApiQmsDbContext _context;
        public InspectUnhealthyRepository(ApiQmsDbContext context) : base(context)
        {
            _context = context;
        }

        public CommonImportResult ImportInspectUnhealthy(IEnumerable<InspectUnhealthyTemplate> datas, int projectid)
        {
            var errors = new List<string>();
            var rowIndex = 1;
            //检查输入信息
            var entities = new List<siger_qms_inspection_unhealthy>();
            foreach (var data in datas)
            {
                rowIndex++;
                //获取相关实体
                if(string.IsNullOrEmpty(data.name) || string.IsNullOrEmpty(data.category) || string.IsNullOrEmpty(data.code))
                {
                    errors.Add($"{rowIndex},{(int)RequestEnum.ParameterMiss}");
                }
                var category = _context.siger_qms_inspection_unhealthy_category.FirstOrDefault(
                    f => f.status == (int)RowState.Valid && f.name == data.category && f.projectid == projectid);
                if (category == null)
                {
                    errors.Add($"{rowIndex},{1950561}");
                }
                if(category != null)
                {
                    var exsit = _context.siger_qms_inspection_unhealthy.FirstOrDefault(
                        f => f.status == (int)RowState.Valid && f.name == data.name && f.categoryid == category.id && f.projectid == projectid);
                    var excelExsit = datas.Count(t => t.name == data.name && t.category == data.category);
                    if (exsit != null || excelExsit > 1)
                    {
                        errors.Add($"{rowIndex},{(int)RequestEnum.NameHasExist}");
                    }
                }               
                if (!Regex.Match(data.code, @"^[a-zA-Z0-9]{5}$").Success)
                {
                    errors.Add($"{rowIndex},{(int)RequestEnum.UnhealthyCodeFormatError}");
                }
                var codeExsit = _context.siger_qms_inspection_unhealthy.FirstOrDefault(
                    f => f.status == (int)RowState.Valid && f.code == data.code && f.projectid == projectid);
                var excelCodeExsit = datas.Count(t => t.code == data.code);
                if (codeExsit != null || excelCodeExsit > 1)
                {
                    errors.Add($"{rowIndex},{(int)RequestEnum.UnhealthyCodeIsExsit}");
                }
                if (errors.Any())
                {
                    return new CommonImportResult(0, string.Join(";", errors));
                }
                entities.Add(new siger_qms_inspection_unhealthy
                {
                    name = data.name,
                    code = data.code,
                    categoryid = category.id,
                    projectid = projectid
                });
            }
            try
            {
                _context.siger_qms_inspection_unhealthy.AddRange(entities);
                _context.SaveChanges();
                return new CommonImportResult(1, "1");
            }
            catch
            {
                throw;
            }
        }
    }
}
