﻿using System.Collections.Generic;
using Siger.Middlelayer.QmsRepository.Entities;
using Siger.Middlelayer.QmsRepository.Response;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Utility.ImportEntities;

namespace Siger.Middlelayer.QmsRepository.Repositories.Interface
{
    public interface IInspectStandardMaterialRepository : IQmsRepositoryBase<siger_qms_inspection_standard_material>
    {
        IPagedCollectionResult<RepsonseInspectStandardMaterial> GetPagedList(int productid, List<int> sectionid, int projectId, int page, int pagesize);

        IEnumerable<RepsonseInspectStandardMaterial> GetDataList(int productid, List<int> sectionid, int projectId);

        CommonImportResult ImportInspectionStandard(IEnumerable<InspectionStandardMaterialLevelTemplate> standards, int levelCount, int projectid, int userid);

        RepsonseInspectStandardMaterial GetData(int id, int projectId);
    }
}
