﻿using Siger.Middlelayer.Common.ModuleEnum;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;

namespace Siger.Middlelayer.QmsRepository.Request
{
    public class RequestBIChart
    {
        public int productid { get; set; }

        public int sectionid { get; set; }

        public List<int> item { get; set; } = new List<int>();

        public string starttime { get; set; }

        public string endtime { get; set; }

        public QmsBIInterfaceType type { get; set; }

        public string setChunkSize { get; set; }

        public string setGroupSize { get; set; }

        public string setGroupNum { get; set; }
    }

    public class RequestSpcControlChart
    {
        /// <summary>
        /// 
        /// </summary>
        public int setSection { get; set; }

        /// <summary>
        /// 关联变量 的工站 
        /// </summary>
        public int setMachineID { get; set; }

        public int setProductID { get; set; }

        public string setTargetfeature { get; set; }
        /// <summary>
        /// 检验项目
        /// </summary>
        public string setResfeature { get; set; }
        /// <summary>
        /// 相关性项目 ，不区分station
        /// </summary>
        public string setVarfeature { get; set; }


        public int setStarttime { get; set; }

        public int setEndtime { get; set; }

        public int setChunkSize { get; set; }

        public int setGroupSize { get; set; }

        public int setGroupNum { get; set; }
    }

    /// <summary>
    /// 
    /// </summary>
    public class RequestRelationAnalys
    {
        /// <summary>
        /// 工站
        /// </summary>
        [Required(ErrorMessage = "setYstation 是必须的")]
        public int setYstation { get; set; }
        /// <summary>
        /// 产品
        /// </summary>
        [Required(ErrorMessage = "setYProductID 是必须的")]
        public string setYProductCode { get; set; }
        /// <summary>
        /// 检验项目
        /// </summary>
        [Required(ErrorMessage = "setYItem 是必须的")]
        public int setYItem { get; set; }
        /// <summary>
        /// 开始时间
        /// </summary>
        [Required(ErrorMessage = "setStarttime 是必须的")]
        public DateTime setStarttime { get; set; }
        /// <summary>
        /// 结束时间
        /// </summary>
        [Required(ErrorMessage = "setEndtime 是必须的")]
        public DateTime setEndtime { get; set; }

        /// <summary>
        /// 关联性选择 X轴 检验项
        /// </summary>
        [Required(ErrorMessage = "setXItems 是必须的")]
        public List<int> setXItems { get; set; }
        public int page { get; set; } = 1;
        public int pageSize { get; set; } = 10;
    }
}
