﻿using Siger.Middlelayer.Common.Extensions;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations.Schema;
using System.Linq;
using System.Text;

namespace Siger.Middlelayer.Repository.Entities
{
    public class siger_project_working_group : ConfigEntityBase
    {
        public string name { get; set; } = string.Empty;

        public int section_id { get; set; } = 0;

        public string user_mids { get; set; } = string.Empty;

        public int interval { get; set; } = 0;

        public string shift_ids { get; set; } = string.Empty;

        public DateTime start_date { get; set; }

        public DateTime create_time { get; set; } = DateTime.Now;

        public int creator_mid { get; set; } = 0;

        public int project_id { get; set; } = 0;

        /// <summary>
        /// 班组对多个排班人员集合
        /// </summary>
        [NotMapped]
        public List<int> midSplit { get { return user_mids.TrimEnd(',').Split(',').Select(x => x.ToInt()).ToList(); } }
        [NotMapped]
        public List<int> shiftSplit { get { return shift_ids.TrimEnd(',').Split(',').Select(x => x.ToInt()).ToList(); } }
    }
}
