﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Threading.Tasks;
using Siger.Middlelayer.Repository.Paged;

namespace Siger.Middlelayer.Repository
{
    public interface IRepository
    {

    }

    public interface IRepositoryBase<TEntity> : IRepository where TEntity : EntityBase
    {
        void Insert(TEntity entity);

        Task InsertAsync(TEntity entity);

        void Insert(IEnumerable<TEntity> entities);

        Task InsertAsync(IEnumerable<TEntity> entities);

        void Delete(object id);

        Task DeleteAsync(object id);

        void Delete(TEntity entity);

        Task DeleteAsync(TEntity entity);

        Task UpdateAsync(TEntity entity);

        void Update(TEntity entity);

        TEntity Get(object key);

        Task<TEntity> GetAsync(object key);

        TEntity Get(Expression<Func<TEntity, bool>> predicate);

        Task<TEntity> GetAsync(Expression<Func<TEntity, bool>> predicate);

        bool IsExist(Expression<Func<TEntity, bool>> predicate);

        Task<bool> IsExistAsync(Expression<Func<TEntity, bool>> predicate);

        IQueryable<TEntity> GetList(Expression<Func<TEntity, bool>> predicate = null, string orderByPropertyName = null, bool desc = true);

        Task<IQueryable<TEntity>> GetListAsync(Expression<Func<TEntity, bool>> predicate = null, string orderByPropertyName = null, bool desc = true);

        IPagedCollectionResult<TEntity> GetPagedList(int pageIndex, int pageSize, 
            Expression<Func<TEntity, bool>> predicate = null, string orderByPropertyName = null, bool desc = true);

        Task<IPagedCollectionResult<TEntity>> GetPagedListAsync(int pageIndex, int pageSize, 
            Expression<Func<TEntity, bool>> predicate = null, string orderByPropertyName = null, bool desc = true);

        #region 执行Sql方法
        int ExecSqlCommond(string sql);
        #endregion 
    }
}
