﻿using System.Collections.Generic;
using Siger.Middlelayer.Repository.Data;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Repository.Response;

namespace Siger.Middlelayer.Repository.Repositories.Interface
{
    public interface ISigerProjectLevelSectionMachineRepository : IApiConfigRepositoryBase<siger_project_level_section_machine>
    {
        ResponseGetSectionMachine GetSectionMachine(int projectId, int sectionid);

        IEnumerable<ResponseIdName> GetStations(int projectId);

        /// <summary>
        ///  获取产线层级子级
        /// </summary>
        /// <param name="id"></param>
        /// <param name="projectid"></param>
        /// <returns></returns>
        IEnumerable<int> GetLevelSectionIds(int id, int projectid);

        IEnumerable<siger_project_level_section> GetLastSection(int projectId);

        IEnumerable<MachinSectionInfo> GetMachinSectionInfos(IEnumerable<int> machineIds, int projectId);

        IEnumerable<siger_project_station> GetGroupStationsByUserId(int userId, int time);

        IEnumerable<siger_project_level_section> GetSectionTreeBySectionIds(IEnumerable<int> sectionIds, int projectId);


        IEnumerable<ResponseIdName> GetNCStations(int projectId);

        ResponseGetSectionMachine GetNCSectionMachine(int projectId, int sectionid);

        int GetSecondLevelId(int projectId);
    }
}