﻿using Siger.Middlelayer.Repository.Data;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Repository.Response;
using System.Collections.Generic;

namespace Siger.Middlelayer.Repository.Repositories.Interface
{
    public interface ISigerProjectProductReport : IApiConfigRepositoryBase<siger_project_product_report>
    {
        

        int GetLastSectionRoute(string productDrawCode, int levelId, int projectId);

        IEnumerable<int> GetSectionIdsInRoute(string productDrawCode, int levelId, int projectId);
        IPagedCollectionResult<ResponseProductReport> ProductReportDataByCode(int pid, string code, string starttime, string endtime, int page, int pagesize);
        int InsertProductReportData(siger_project_product_report model);
        int UpdateProductReportData(siger_project_product_report model);
        double ProductWorkingHours(int projectId, string productCode);

        IEnumerable<ResponseEmpReportDetails> GetReportDetails(int uid, int shiftid, long stime, long etime, int projectId);
    }
}
