﻿using System.Collections.Generic;
using Siger.Middlelayer.Repository.Data;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Repository.Request;
using Siger.Middlelayer.Repository.Response;

namespace Siger.Middlelayer.Repository.Repositories.Interface
{
    public interface ISigerProjectUserRepository:IApiConfigRepositoryBase<siger_project_user>
    {
        CurrentUserInfo GetCurrentUserInfo(int mid);

        ProjectUserInfo GetUserInfoById(int id);

        UserInfo GetUserInfo(int mid);
        IEnumerable<UserInfo> GetUserInfoList(int projectId);

        UserInfo GetUserInfoByName(string name);

        IEnumerable<IdTitle> GetUserInfoKey(int mid, int projectid);

        ResponseKeyValueResult AddProjectUserKeyValue(int mid, IList<ProjectUserKeyValue> keyValues);

        bool DeleteProjectUserKeyValue(int id);

        IEnumerable<ProjectUserInfo> GetUsersBySectionid(int sectionId, int projectId);

        IPagedCollectionResult<UserGroupShiftInfo> GetUserGroupShiftInfo(List<int> levelids, int sectionid, List<int> groupids,
            int groupid, int shiftid, string shiftTitle, int startTime, int endTime, int projectid, int page, int pagesize);

        IEnumerable<SectionGroupShift> GetSectionGroupShifts(int departid, int sectionid, int unixNow, int projectid);

        ResponseGetUserShiftById GetUserShiftById(int id);

        IEnumerable<ResponseGetProductionUser> GetProductionUsers(int projectId, int typeId);

        int UpdateUserAppKey(int mid, string appKey, int projectId);

        string GetUserAppKey(int mid, int projectId);

        int RefreshOnLine(int mid, int projectId);

        bool IsOnlie(int mid, int projectId, string key);

        string GetUserMobile(int mid, int projectId);

        IEnumerable<UserGroupShiftInfo> GetUserGroupShiftList(List<int> groupids, int groupid, int shiftid,
            int startTime, int endTime);

        IEnumerable<ResponseGetUserList> GetProjectUserList(int type, int sectionType, int projectId);

        IEnumerable<ResponseGetSectionUserList> GetSectionUserList(int sectionId, int projectId);
        List<siger_project_machine> GetMachinesByMid(int pid, int mid);
        siger_project_user GetProjectManager(int projectId);
    }
}