﻿using System.Collections.Generic;
using Siger.Middlelayer.Repository.Data;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Repository.Request;
using Siger.Middlelayer.Utility.ImportEntities;

namespace Siger.Middlelayer.Repository.Repositories.Interface
{
    public interface ISigerUserRepository:IApiConfigRepositoryBase<siger_user>
    {
        IPagedCollectionResult<AdminUser> GetAdmins(int userType, int page, int pagesize);

        IPagedCollectionResult<ProjectUser> GetPagedUsers(int sectionid, int usergroupid, string name, int gender,
            string work_code, int projectid, int page, int pagesize);

        CommonImportResult ImportUsers(IEnumerable<UserList> users, int projectid);

        IList<ProjectUser> ExportUsers(int sectionid, int usergroupid, string name, int sex, string work_code,
            int projectid);

        bool CheckShiftTimes(List<TimeCompare> times, int sectionid, int departid);

        IEnumerable<siger_user_power> GetUserPowers(int userId, int projectId);

        IEnumerable<siger_user_power> GetModulePowers(int userId, int projectId, string moduleName);

        IEnumerable<siger_user_power> GetAppPowers(int userId, int projectId);
    }
}