﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Repository.Data;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Repository.Repositories.Interface;


namespace Siger.Middlelayer.Repository.Repositories
{
   internal class SigerProjectEmailConfigRepository : ApiConfigRepositoryBase<SigerProjectEmailConfig>, ISigerProjectEmailConfig
    {
        private readonly ApiConfigDbContext _context;
        public SigerProjectEmailConfigRepository(ApiConfigDbContext context) : base(context)
        {
            _context = context;
        }

        //public EmaiHostCfg GetEmaiHost(int projectId)
        //{
        //    var query = from s in _context.siger_project_email_server
        //                join c in _context.siger_project_email_config on s.id equals c.server
        //                where s.project==c.project  && s.project==projectId
        //                select new EmaiHostCfg
        //                {
        //                     Host=s.server,
        //                     FromEmail=c.send,
        //                     Password=c.code
        //                };
        //    return query.FirstOrDefault();
        //}

        public IEnumerable<MachineTitle> GetMachineTitles(int projectId,List<int>mids, int section, string title)
        {

            var machines = GetLevelSectionMachineIds(section, projectId);
            var effsectionIds = machines.Except(mids).ToList();
            Expression<Func<MachineTitle, bool>> FunNum = f => true;
            var queryList = from m in _context.siger_project_machine
                            join s in _context.siger_project_machine_attribution on m.id equals s.machine 
                            where effsectionIds.Contains(m.id) && m.status == (int)RowState.Valid && s.status == (int)RowState.Valid
                                  && m.projectid == projectId
                            select new MachineTitle
                            {
                                MachineId = m.id,
                                Code = m.code,
                                Title = m.title
                            };
            if (!string.IsNullOrEmpty(title))
            {
                FunNum = q => q.Title.Contains(title);
            }
            return queryList.Where(FunNum).OrderBy(o => o.MachineId).AsEnumerable();

        }
    }
}
