﻿using System;
using System.Collections.Generic;
using System.Linq;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.Extensions;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Repository.Data;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Repository.Repositories.Interface;

namespace Siger.Middlelayer.Repository.Repositories
{
    internal class SigerUserRolePowerRepository : ApiConfigRepositoryBase<siger_user_role_power>,ISigerUserRolePowerRepository
    {
        private readonly ApiConfigDbContext _context;
        public SigerUserRolePowerRepository(ApiConfigDbContext context) : base(context)
        {
            _context = context;
        }

        public IEnumerable<UserPower> GetNormalUserRoleMaintenance(int roleid, int projectTypeRoleId)
        {
            var powerIds = _context.siger_user_role_power.Where(q => q.roleid == roleid).Select(m => m.powerid).ToList();

            var query = from q in _context.siger_user_role_power
                join ro in _context.siger_user_power on q.powerid equals ro.id into po
                from ro in po.DefaultIfEmpty()
                where q.status == (int) RowState.Valid && ro.status == (int) RowState.Valid
                                                       && q.roleid == projectTypeRoleId
                select new UserPower
                {
                    id = ro != null ? ro.id : 0,
                    description = ro != null ? ro.description: "",
                    name = ro != null ? ro.name : "",
                    value = ro != null ? ro.value : "",
                    parent = ro != null ? ro.parent : "",
                    parentvalue = ro != null ? ro.parentvalue : "",
                    status = ro != null ? ro.status : 0,
                    Checked = ro != null ? powerIds.Contains(ro.id) ? "1" : "0" : "0"
                };

            return query.ToList();
        }

        public List<ResponseUserPower> GetNormalUserRoleMaintenanceTree(int roleid, int projectTypeRoleId)
        {
            var resp = new List<ResponseUserPower>();
            var typeModel = _context.siger_project_type.FirstOrDefault(q => q.id == projectTypeRoleId && q.status == (int)RowState.Valid);
            var clientType = Enum.GetNames(typeof(PowerType));
            //菜单类型
            foreach (var item in clientType)
            {
                var clientData = new ResponseUserPower
                {
                    title = item,
                    type = (int)Enum.Parse(typeof(PowerType), item),
                    expand = true
                };
                resp.Add(clientData);
            }
            if (typeModel != null)
            {
                var powerModel = from q in _context.siger_user_role_power
                    join ro in _context.siger_user_power on q.powerid equals ro.id into po
                    from ro in po.DefaultIfEmpty()
                    where q.status == (int) RowState.Valid && ro.status == (int) RowState.Valid
                                                           && q.roleid == projectTypeRoleId
                    select ro;
                var powerids = _context.siger_user_role_power.Where(q => q.roleid == roleid).Select(m => m.powerid).ToList();
                foreach (var item in resp)
                {
                    item.children = GetPowerData(item.id, item.type, powerModel.ToList(), powerids);
                }
            }
            return resp;
        }

        public List<ResponseUserPower> GetNormalUserGroupRoleMaintenanceTree(int roleid, int projectTypeRoleId, int sectionRoleId)
        {
            var resp = new List<ResponseUserPower>();
            var typeModel = _context.siger_project_type.FirstOrDefault(q => q.id == projectTypeRoleId && q.status == (int)RowState.Valid);
            var clientType = Enum.GetNames(typeof(PowerType));
            //菜单类型
            foreach (var item in clientType)
            {
                var clientData = new ResponseUserPower
                {
                    title = item,
                    type = (int)Enum.Parse(typeof(PowerType), item),
                    expand = true
                };
                resp.Add(clientData);
            }
            if (typeModel != null)
            {
                var powerModel = from q in _context.siger_user_role_power
                    join ro in _context.siger_user_power on q.powerid equals ro.id into po
                    from ro in po.DefaultIfEmpty()
                    where q.status == (int)RowState.Valid && ro.status == (int)RowState.Valid
                                                          && q.roleid == projectTypeRoleId
                    select ro;
                var powerids = _context.siger_user_role_power.Where(q => q.roleid == roleid).Select(m => m.powerid).ToList();
                var sectionPowerIds = _context.siger_user_role_power.Where(q => q.roleid == sectionRoleId).Select(m => m.powerid).ToList();
                foreach (var item in resp)
                {
                    item.children = GetUserGroupPowerData(item.id, item.type, powerModel.ToList(), powerids, sectionPowerIds);
                }
            }
            return resp;
        }

        private List<ResponseUserPower> GetUserGroupPowerData(int parent, int type, List<siger_user_power> powerModel, List<int> powerids, List<int> sectionPowerIds)
        {
            var menus = new List<ResponseUserPower>();
            var powerData = powerModel.Where(f => f.parent.ToInt() == parent && f.status != (int)RowState.Invalid && f.type.Equals(type));
            if (powerData == null)
            {
                return null;
            }
            foreach (var item in powerData)
            {
                if (sectionPowerIds.Contains(item.id))
                {
                    var data = Mapper<siger_user_power, ResponseUserPower>.Map(item);
                    data.title = item.name;
                    data.children = GetUserGroupPowerData(item.id, type, powerModel, powerids, sectionPowerIds);
                    data.@checked = data.children.Count == 0 && powerids.Contains(item.id);
                    menus.Add(data);
                }
            }
            return menus;
        }

        private List<ResponseUserPower> GetPowerData(int parent, int type, IEnumerable<siger_user_power> powerModel, IEnumerable<int> powerids)
        {
            var menus = new List<ResponseUserPower>();
            var powerData = powerModel.Where(f => f.parent.ToInt() == parent && f.status != (int)RowState.Invalid && f.type.Equals(type));
            foreach (var item in powerData)
            {
                var data = Mapper<siger_user_power, ResponseUserPower>.Map(item);
                data.title = item.name;
                data.children = GetPowerData(item.id, type, powerModel, powerids);
                data.@checked = data.children.Count == 0 && powerids.Contains(item.id);
                menus.Add(data);
            }
            return menus;
        }
    }
}
