﻿using System.ComponentModel.DataAnnotations;

namespace Siger.Middlelayer.Repository.Request
{
    public class RequestAddSparepart
    {
        [Required(ErrorMessage = "SparepartCodeIsEmpty")]
        public string code { get; set; }

        [Required(ErrorMessage = "TitleIsEmpty")]
        public string title { get; set; }

        public string param { get; set; }

        public string description { get; set; }

        public string price { get; set; } = string.Empty;

        public string material { get; set; }

        public string brand { get; set; }

        [Required(ErrorMessage = "MaxStockIsEmpty")]
        public string max_sku { get; set; }

        [Required(ErrorMessage = "MinStockIsEmpty")]
        public string mini_sku { get; set; }

        public string sku { get; set; }

        [Required(ErrorMessage = "StockLocationIsEmpty")]
        public string warehouse { get; set; }

        public string supplier { get; set; }

        [Required(ErrorMessage = "StockReportUserIsEmpty")]
        public string sku_report_mid { get; set; }

        public string unit { get; set; }

        public string delivery_time { get; set; }

        public string remark { get; set; }

        public string image { get; set; }

        public string is_substitute { get; set; } = string.Empty; //置换

        public string purchase_status { get; set; } = string.Empty; //采购中

        public string is_common { get; set; } = "1"; //标准件

        public string subsu { get; set; }

        public string machinetype { get; set; }

        public string sectionid { get; set; }

        public string spareparttype { get; set; }

        public string is_standard { get; set; }

        /// <summary>
        /// 维修上限
        /// </summary>
        public string repair_upperlimit { get; set; } = string.Empty;

        public string approvaluser { get; set; } = string.Empty;

        public string sku_limit { get; set; } = string.Empty;
    }

    public class RequestUpdateSparepart : RequestAddSparepart
    {
        [Required(ErrorMessage = "IdIsEmpty")]
        public int id { get; set; }
    }
}

