﻿using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;

namespace Siger.Middlelayer.Repository.Request
{
    public class RequestEmailCfg
    {
        /// <summary>
        /// 发件箱
        /// </summary>
        /// 
        [Required(ErrorMessage = "Email required")]
        public string Email { get; set; }

        /// <summary>
        /// 邮箱服务地址
        /// </summary>
        /// 
        [Required(ErrorMessage = "Server required")]
        public string Host { get; set; }
        /// <summary>
        /// 授权码
        /// </summary>
        /// 
        [Required(ErrorMessage = "Code required")]
        public string Code { get; set; }
    }

    public class RequestSettingMachineEmail
    {
        public List<int> Mids { get; set; }
        public List<int> Users { get; set; }
    }
    public class RequestModifySettingMachineEmail
    {
        public int MachineId { get; set; }
        public List<int> Users { get; set; }
    }

    public class RequestSettingMail
    {
        [Required(ErrorMessage = "FirstEmailIsEmpty")]
        public string from { get; set; }

        [Required(ErrorMessage = "FirstHostIsEmpty")]
        public string host { get; set; }

        [Required(ErrorMessage = "FirstPasswordIsEmpty")]
        public string password { get; set; }

        /// <summary>
        /// user.mid
        /// </summary>
        public string to { get; set; }
    }
}
