﻿namespace Siger.Middlelayer.Repository.Response
{
    public abstract class ResponseMachineBase
    {
        public int id { get; set; }
        public string title { get; set; }
        public string description { get; set; }
        public string code { get; set; }
        public string model { get; set; }
        public string factory { get; set; }
        public string factory_code { get; set; }
        public string made_date { get; set; }
        public int time { get; set; }
        public int brand { get; set; }
        /// <summary>
        /// 1->自用；2->出租；3->出借；4->其他在用；5->停用；6->闲置；7->报废 ；8->盘点中 （当前盘点时的状态）
        /// </summary>
        public int current_status { get; set; }
        public string image { get; set; }
        public string ip { get; set; }
        public string savedaycomment { get; set; }
        public string savedays { get; set; }
        public int sorting { get; set; }
        public int typeid { get; set; }
        public int ptypeid { get; set; }

        public int tool_count { get; set; }
        public int attribution { get; set; }
        public string type_name { get; set; }
        public string remarks { get; set; }
        public string asset_code { get; set; }
}

    public class ResponseGetResponseMachine: ResponseMachineBase
    {
        
    }

    public class ResponseGetResponseMachineList: ResponseMachineBase
    {
        public int projectid { get; set; }

        public string current { get; set; }

        public int mid { get; set; }

        public string stas { get; set; }

        public string station { get; set; }
    }

    public class ResponseGetResponseExtendMachineList : ResponseGetResponseMachineList
    {
        /// <summary>
        /// Machine Name
        /// </summary>
        public string machine_name { get; set; } = string.Empty;

        /// <summary>
        /// 测试应用产品
        /// </summary>
        public string typical_application { get; set; } = string.Empty;

        /// <summary>
        /// 尺寸-内径
        /// </summary>
        public string inside_diameter { get; set; } = string.Empty;

        /// <summary>
        /// 尺寸-外径
        /// </summary>
        public string outside_diameter { get; set; } = string.Empty;

        /// <summary>
        /// 径向载荷
        /// </summary>
        public string radial_load { get; set; } = string.Empty;

        /// <summary>
        /// 轴向载荷
        /// </summary>
        public string axial_load { get; set; } = string.Empty;

        /// <summary>
        /// 压力
        /// </summary>
        public string pressure { get; set; } = string.Empty;

        /// <summary>
        /// 转速
        /// </summary>
        public string speed { get; set; } = string.Empty;

        /// <summary>
        /// 温度
        /// </summary>
        public string temperature { get; set; } = string.Empty;

        /// <summary>
        /// 转向
        /// </summary>
        public string rotation { get; set; } = string.Empty;

        /// <summary>
        /// 样本润滑
        /// </summary>
        public string sample_lubrication { get; set; } = string.Empty;

        /// <summary>
        /// 设备用油-润滑
        /// </summary>
        public string oil_lubrication { get; set; } = string.Empty;

        /// <summary>
        /// 设备用油-液压
        /// </summary>
        public string oil_hydraulic { get; set; } = string.Empty;

        /// <summary>
        /// 信号采集
        /// </summary>
        public string signal_monitor { get; set; } = string.Empty;

        /// <summary>
        /// 测试工位
        /// </summary>
        public string position { get; set; } = string.Empty;

        /// <summary>
        /// 设备尺寸
        /// </summary>
        public string machine_size { get; set; } = string.Empty;

        /// <summary>
        /// 设备简称
        /// </summary>
        public string machine_shortname { get; set; } = string.Empty;

        /// <summary>
        /// 负责人
        /// </summary>
        public string responsor { get; set; } = string.Empty;
    }

    public class ResponseGetResponseMachineInfo : ResponseMachineBase
    {
        public int projectid { get; set; }
    
        public int mid { get; set; }

        public string station { get; set; }

        public int section_id { get; set; }

        public string section { get; set; }
        public int attribute { get; set; }

        public int machinelevel { get; set; }

        public int category { get; set; }
    }

    public class ResponseGetResponseMachines : ResponseMachineBase
    {
        public string lmachine { get; set; }

        public string station { get; set; }
        public string typetitle { get; set; }
        public string current { get; set; }
        public int section_id { get; set; }
    }

    public class ResponseGetResponseExtendMachines : ResponseMachineBase
    {
        public int projectid { get; set; }

        public int mid { get; set; }


        public string section { get; set; }
        public int attribute { get; set; }

        public int machinelevel { get; set; }

        public int category { get; set; }

        public string lmachine { get; set; }

        public string station { get; set; }
        public string typetitle { get; set; }
        public string current { get; set; }
        public int section_id { get; set; }

        /// <summary>
        /// Machine Name
        /// </summary>
        public string machine_name { get; set; } = string.Empty;

        /// <summary>
        /// 测试应用产品
        /// </summary>
        public string typical_application { get; set; } = string.Empty;

        /// <summary>
        /// 尺寸-内径
        /// </summary>
        public string inside_diameter { get; set; } = string.Empty;

        /// <summary>
        /// 尺寸-外径
        /// </summary>
        public string outside_diameter { get; set; } = string.Empty;

        /// <summary>
        /// 径向载荷
        /// </summary>
        public string radial_load { get; set; } = string.Empty;

        /// <summary>
        /// 轴向载荷
        /// </summary>
        public string axial_load { get; set; } = string.Empty;

        /// <summary>
        /// 压力
        /// </summary>
        public string pressure { get; set; } = string.Empty;

        /// <summary>
        /// 转速
        /// </summary>
        public string speed { get; set; } = string.Empty;

        /// <summary>
        /// 温度
        /// </summary>
        public string temperature { get; set; } = string.Empty;

        /// <summary>
        /// 转向
        /// </summary>
        public string rotation { get; set; } = string.Empty;

        /// <summary>
        /// 样本润滑
        /// </summary>
        public string sample_lubrication { get; set; } = string.Empty;

        /// <summary>
        /// 设备用油-润滑
        /// </summary>
        public string oil_lubrication { get; set; } = string.Empty;

        /// <summary>
        /// 设备用油-液压
        /// </summary>
        public string oil_hydraulic { get; set; } = string.Empty;

        /// <summary>
        /// 信号采集
        /// </summary>
        public string signal_monitor { get; set; } = string.Empty;

        /// <summary>
        /// 测试工位
        /// </summary>
        public string position { get; set; } = string.Empty;

        /// <summary>
        /// 设备尺寸
        /// </summary>
        public string machine_size { get; set; } = string.Empty;

        /// <summary>
        /// 设备简称
        /// </summary>
        public string machine_shortname { get; set; } = string.Empty;

        /// <summary>
        /// 负责人
        /// </summary>
        public string responsor { get; set; } = string.Empty;
    }

    public class ResponseGetResponseMachineItem : ResponseMachineBase
    {
        public string station { get; set; }
        public string title1 { get; set; }
        public int section_id { get; set; }
    }

    public class ResponseMachineToolQrCode
    {
        public int machine_type { get; set; }

        public string tool_number { get; set; }

        public int mid { get; set; }
    }
}
