﻿using Siger.Middlelayer.Common.ModuleEnum;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations.Schema;

namespace Siger.Middlelayer.Repository.Response
{
    public class ResponseProductReport
    {
        public int id { get; set; }
        /// <summary>
        /// 开始时间
        /// </summary>
        public DateTime start_time { get; set; }

        /// <summary>
        /// 结束时间
        /// </summary>
        public DateTime end_time { get; set; }


        /// <summary>
        /// 报工时间
        /// </summary>
        public DateTime time { get; set; }


        /// <summary>
        /// 生产执行人工号
        /// </summary>
        public string worker_code { get; set; }

        /// <summary>
        /// 生产执行人姓名
        /// </summary>
        public string worker_name { get; set; }

        /// <summary>
        /// 图纸号
        /// </summary>
        public string draw_number { get; set; }

        /// <summary>
        /// 产品名称
        /// </summary>
        public string product_name { get; set; }
        public string product_code { get; set; }
        public int station { get; set; }
        public string station_value { get; set; }
        public string process { get; set; }
        public int status { get; set; }
        public int okcount { get; set; }
        /// <summary>
        /// 工废
        /// </summary>
        public int industrial_waste { get; set; }
        /// <summary>
        /// 料废
        /// </summary>
        public int material_waste { get; set; }
        /// <summary>
        /// 总产量
        /// </summary>
        public int output { get; set; }
        /// <summary>
        /// 工令单
        /// </summary>
        public string code { get; set; }
        /// <summary>
        /// 工艺id
        /// </summary>
        public int processId { get; set; }
        public int uid { get; set; }
        public string processType { get; set; }
    }

    public class ResponseGetProducesReport
    {
        public int id { get; set; }

        public int plan_id { get; set; }

        public int machineid { get; set; }

        public string code { get; set; }

        public string produced_program_number { get; set; } = string.Empty;

        public int start_time { get; set; }

        public int end_time { get; set; }

        public int actual_output { get; set; }

        public int output { get; set; }

        public int time { get; set; }

        public int nok_number { get; set; }

        public string worker_code { get; set; }

        public string worker_name { get; set; }

        public string draw_number { get; set; } = string.Empty;

        public string product_name { get; set; }

        public string product_code { get; set; }

        public int section_id { get; set; }

        public string start_end_time { get; set; }

        public string title { get; set; } = "";

        public string daytime { get; set; } = "";

        public List<ResponseIdName> users { get; set; }

        public string orderNumber { get; set; } = "";

        public string program_number { get; set; } = "";

        public string machineLocation { get; set; } = "";

        public int approval_status { get; set; }

        public int approval_usermid { get; set; } = 0;

        public string approval_username { get; set; } = "";

        public string approval_datetime { get; set; } = "";

        public string route_name { get; set; }

        public int plan_type { get; set; }
        public int station { get; set; }
        public int processid { get; set; }
        public int uid { get; set; }
        
        public int industrial_waste { get; set; }
        public int material_waste { get; set; }
        public int approval_time { get; set; }

        public double rest_minutes { get; set; }
        public ResponseGetProducesReport()
        {
            users = new List<ResponseIdName>();
        }
    }

    /// <summary>
    /// 查询人员报工信息回参
    /// </summary>
    public class ResponseUserReport
    {
        public int oksum { get; set; }
        public int noksum { get; set; }
        public List<ResponseUserReportDetails> data { set; get; }
    }
    public class ResponseUserReportDetails
    {
        /// <summary>
        /// 产品名称
        /// </summary>
        public string product_name { get; set; }
        /// <summary>
        /// 工序名称
        /// </summary>
        public string route_name { get; set; }
        /// <summary>
        /// 合格数
        /// </summary>
        public int ok_number { get; set; }
        /// <summary>
        /// 不合格数
        /// </summary>
        public int nok_number { get; set; }
        /// <summary>
        /// 报工时间
        /// </summary>
        public string report_time { get; set; }
    }
    /// <summary>
    /// 
    /// </summary>
    public class ResponsePlanReportDetails
    {
        public int plan_id { get; set; }
        public int plandDts_id { get; set; }
    
        /// <summary>
        /// 工令单
        /// </summary>
        public string code { get; set; }
        /// <summary>
        /// 产品名称
        /// </summary>
        public string product_name { get; set; }
        public int route_id { get; set; }
        /// <summary>
        /// 工序名称
        /// </summary>
        public string route_name { get; set; }
        /// <summary>
        /// 工序顺序
        /// </summary>
        public int route_serinum { get; set; }
        /// <summary>
        /// 合格数
        /// </summary>
        public int ok_number { get; set; }
        /// <summary>
        /// 不合格数
        /// </summary>
        public int nok_number { get; set; }
        /// <summary>
        /// 报工时间
        /// </summary>
        public string report_time { get; set; }
        /// <summary>
        /// 订单数量
        /// </summary>
        public int order_cnt { get; set; }
        /// <summary>
        /// 工单数量（装机数量）
        /// </summary>
        public int order_installCnt { get; set; }
        /// <summary>
        /// 工令单数量
        /// </summary>
        public int quantity { get; set; }
        /// <summary>
        /// 工令单状态
        /// </summary>
        public int status { get; set; }
    }

}
