﻿using System.Collections.Generic;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.TlmRepository.Entities;
using Siger.Middlelayer.TlmRepository.Response;
using Siger.Middlelayer.Utility.ImportEntities;

namespace Siger.Middlelayer.TlmRepository.Repositories.Interface
{
    public interface IToolLifeTechnologyRepository : ITlmRepositoryBase<siger_project_toollife_technology>
    {
        IPagedCollectionResult<ResponseGetTechnologys> GetPagedList(int productId, string draw_code, int macineType,
            int page, int pagesize, int toexcel, string route,int projectId);

        IEnumerable<ResponseGetTechCondition> GetTechConditions(int productId, string draw_code, int macineType,
            int projectId);

        CommonImportResult ImportTechnology(IEnumerable<TechnologyList> techs, int projectid, int userId);

        IEnumerable<ResponseGetTechnologys> GetDataList(int productId, string route,string machineid, int projectId);
    }
}
