using Siger.Middlelayer.Repository;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.TlmRepository.Entities;
using Siger.Middlelayer.TlmRepository.Repositories.Interface;
using Siger.Middlelayer.TlmRepository.Request;
using Siger.Middlelayer.Utility.ImportEntities;
using System;
using System.Collections.Generic;
using System.Text;
using System.Linq;
using System.Linq.Expressions;
using Siger.Middlelayer.Repository.Response;
using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.TlmRepository;

namespace Siger.MiddlelayerTlmRepository.Repositories
{
    public class ProjectToollifeTestRepository : RepositoryBase<ProjectToollifeTestEntity>, IProjectToollifeTestRepository
    {
        private readonly ApiTlmDbContext _context;
        public ProjectToollifeTestRepository(ApiTlmDbContext context) : base(context)
        {
            _context = context;
        }

        public IPagedCollectionResult<ProjectToollifeTestEntity> GetPagedList(RequestProjectToollifeTest req)
        {
            //todo:根据实际业务构建查询条件
            Expression<Func<ProjectToollifeTestEntity, bool>> conditionCommon = q => q.Status == (int)RowState.Valid && q.Projectid == req.ProjectId;;
            var predicates = conditionCommon;
            var totalCount = _context.ProjectToollifeTestEntities.Count(predicates);
            List<ProjectToollifeTestEntity> entities;
            if (req.Page != 0)
            {
                entities = _context.ProjectToollifeTestEntities.Where(predicates).OrderByDescending(o=>o.Id).Skip((req.Page - 1) * req.PageSize).Take(req.PageSize).AsNoTracking().ToList();
            }
            else
            {
                entities = _context.ProjectToollifeTestEntities.Where(predicates).OrderByDescending(o=>o.Id).AsNoTracking().ToList();
            }
            return new PagedCollectionResult<ProjectToollifeTestEntity>(entities, totalCount);

        }
    }
}
