﻿using System.Collections.Generic;
using System.Linq;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Repository.Response;
using Siger.Middlelayer.TlmRepository.Entities;
using Siger.Middlelayer.TlmRepository.Repositories.Interface;

namespace Siger.Middlelayer.TlmRepository.Repositories
{
    internal class ToollifeStoragePlatformRepository : TlmRepositoryBase<siger_project_toollife_storage_platform>, IToollifeStoragePlatformRepository
    {
        private readonly ApiTlmDbContext _context;
        public ToollifeStoragePlatformRepository(ApiTlmDbContext context) : base(context)
        {
            _context = context;
        }

        public IEnumerable<ResponseKeyValue> GetAllMeterials(int projectId)
        {
            var query = _context.siger_tr_materials.Where(q =>
                    q.projectId == projectId && q.status == (int) RowState.Valid).OrderBy(m => m.name)
                .Select(m => new ResponseKeyValue(m.pn, m.name));

            return query.AsEnumerable();
        }

        public IEnumerable<ResponseKeyValue> GetAllSuppilers(int projectId)
        {
            var query = _context.siger_wms_bussinese_contacts.Where(q =>
                q.projectid == projectId && q.status == (int) RowState.Valid
                                         && q.supply_type == 1).OrderBy(m => m.name)
                .Select(m => new ResponseKeyValue(m.serial_number, m.name));

            return query.AsEnumerable();
        }
    }
}
