﻿using System.ComponentModel.DataAnnotations;
using Siger.Middlelayer.Common.ModuleEnum;

namespace Siger.Middlelayer.ToolRepository.Request
{
    /// <summary>
    /// 控制上下限/极值轮廓线 参数
    /// </summary>
    public class RequestToolControlLineExtremum
    {
        [Required(ErrorMessage = "StartTimeNotNull")]
        public long starttime { get; set; }
        [Required(ErrorMessage = "EndTimeNotNull")]
        public long endtime { get; set; }

        [Required(ErrorMessage = "ProgramNoNotNull")]
        public string programno { get; set; }

        /// <summary>
        /// 主轴 名称
        /// </summary>
        
        public int spindle_id { get; set; }

        /// <summary>
        /// 刀位 名称
        /// </summary>
        public int cutter_location_id { get; set; }
        /// <summary>
        /// 设备ID
        /// </summary>
        public int machineId { get; set; }

        /// <summary>
        /// 标定
        /// </summary>
        public ToolMarkType cutter_type;

        /// <summary>
        /// 样本数量
        /// </summary>
        public int num { get; set; }

        public int blx_id { get; set; }

        /// <summary>
        /// 产品质量异常描述
        /// </summary>
        public int quanlitydesc { get; set; }
    }

    public class RequestSetControline
    {
        /// <summary>
        /// trueCutter.id
        /// </summary>
        public int Id { get; set; }
        [Required(ErrorMessage = "StartTimeNotNull")]
        public string Starttime { get; set; }
        [Required(ErrorMessage = "EndTimeNotNull")]
        public string Endtime { get; set; }
        // 标定
        //public ToolMarkTypeNew Cutter_type;

        /// <summary>
        /// 样本数量
        /// </summary>
        public int Num { get; set; }

        /// <summary>
        /// 产品质量异常描述
        /// </summary>
        public int Quanlitydesc { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        public string Remark { get; set; }
    }

}
