﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.Middlelayer.ToolRepository.Response
{
    public class ResponseToolConfig
    {
        public int Id { get; set; }
        public int MachineId { get; set; }
        public string MachineDes { get; set; }
        public int Section { get; set; }
        public string SectionDesc { get; set; }
        public string Spindle { get; set; }
        public string Tool { get; set; }
        public string Program { get; set; }

        public Marktype Marktype { get; set; }
    }
    public class Marktype
    {
        /// <summary>
        ///  空转标定
        /// </summary>
        public int Free { get; set; }
        /// <summary>
        /// 磨损标定
        /// </summary>
        public int Wear { get; set; }
        /// <summary>
        /// 崩刃标定
        /// </summary>
        public int Broken { get; set; }
        /// <summary>
        /// 其他标定
        /// </summary>
        public int Other { get; set; }

    }

    /// <summary>
    /// 标定明细
    /// </summary>
    public class ResponseToolConfigMarkDts
    {
        public int id { get; set; }
        public int Marktype { get; set; }
        public string MarktypeDesc { get; set; }
        public string Begintime { get; set; }
        public string Endtime { get; set; }
        public int Count { get; set; }
        public string User { get; set; }
        public string Time { get; set; }
        public string QuanlityDesc { get; set; }
        public string Remark { get; set; }
    }
   
}
