﻿using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.Common.Configuration;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.TpmRepository.Entities;

namespace Siger.Middlelayer.TpmRepository
{
    public class ApiTpmDbContext : DbContext
    {
        public ApiTpmDbContext()
        {

        }
        public ApiTpmDbContext(DbContextOptions<ApiTpmDbContext> options) : base(options)
        {

        }

        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {

        }

        protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder)
        {
            var useOneDb = ConfigManager.GetValue("DbSetting", "UseOneDb", true);
            if (useOneDb)
            {
                var mySqlConnection = ConfigManager.GetValue("DbSetting", "DbConnection", string.Empty);
                if (!string.IsNullOrEmpty(mySqlConnection))
                {
                    optionsBuilder.UseMySql(mySqlConnection);
                }
            }
            else
            {
                var clusterConnection = ConfigManager.GetValue("DbClusterSetting", "ClusterConnection", string.Empty);
                if (!string.IsNullOrEmpty(clusterConnection))
                {
                    optionsBuilder.UseMySql(clusterConnection);
                }
            }
        }

        public DbSet<siger_user> siger_user { get; set; }
        public DbSet<siger_project_user> siger_project_user { get; set; }
        public DbSet<siger_project_level_section> siger_project_level_section { get; set; }
        public DbSet<siger_project_level_section_machine> siger_project_level_section_machine { get; set; }
        public DbSet<siger_project_usergroup> siger_project_usergroup { get; set; }
        public DbSet<siger_system_config> siger_system_config { get; set; }


        public DbSet<siger_project_repair> siger_project_repair { get; set; }

        public DbSet<siger_project_repair_report> siger_project_repair_report { get; set; }

        public DbSet<siger_project_repair_report_level> siger_project_repair_report_level { get; set; }

        public DbSet<siger_project_machine> siger_project_machine { get; set; }

        public DbSet<siger_project_machine_type> siger_project_machine_type { get; set; }

        public DbSet<siger_project_machine_fault> siger_project_machine_fault { get; set; }

        public DbSet<siger_project_sparepart> siger_project_sparepart { get; set; }

        public DbSet<siger_project_sparepart_type> siger_project_sparepart_type { get; set; }

        public DbSet<siger_project_sparepart_machine> siger_project_sparepart_machine { get; set; }

        public DbSet<siger_project_sparepart_record> siger_project_sparepart_record { get; set; }


        public DbSet<siger_project_plan> siger_project_plan { get; set; }

        public DbSet<siger_project_plan_time> siger_project_plan_time { get; set; }

        public DbSet<siger_project_plan_item> siger_project_plan_item { get; set; }

        public DbSet<siger_project_check> siger_project_check { get; set; }

        public DbSet<siger_project_plan_report> siger_project_plan_report { get; set; }

        public DbSet<siger_project_plan_report_level> siger_project_plan_report_level { get; set; }

        public DbSet<siger_project_plan_record> siger_project_plan_record { get; set; }


        public DbSet<siger_project_station> siger_project_station { get; set; }

        public DbSet<siger_project_user_group> siger_project_user_group { get; set; }

        public DbSet<siger_project_repair_add_user> siger_project_repair_add_user { get; set; }

        public DbSet<siger_app_mute> siger_app_mute { get; set; }

        public DbSet<siger_project_section> siger_project_section { get; set; }

        public DbSet<siger_project_repair_list> siger_project_repair_list { get; set; }

        public DbSet<siger_project_shift> siger_project_shift { get; set; }

        public DbSet<siger_project_repair_cooperate_reason> siger_project_repair_cooperate_reason { get; set; }

        public DbSet<siger_app_project_config> siger_app_project_config { get; set; }

        public DbSet<siger_app_project_message> siger_app_project_message { get; set; }

        public DbSet<siger_app_project_user> siger_app_project_user { get; set; }

        public DbSet<siger_project> siger_project { get; set; }


        public DbSet<siger_project_plan_sign> siger_project_plan_sign { get; set; }
        public DbSet<siger_andon_process> siger_andon_process { get; set; }
        public DbSet<siger_andon_expection_type> siger_andon_expection_type { get; set; }
        public DbSet<siger_andon_info> siger_andon_info { get; set; }
        public DbSet<siger_andon_info_detail> siger_andon_info_detail { get; set; }
        public DbSet<siger_project_working_group> siger_project_working_group { get; set; }
        //public DbSet<siger_project_working_machine_set> siger_project_working_machine_set { get; set; }
        public DbSet<siger_project_production_time> siger_project_production_time { get; set; }
        public DbSet<siger_project_procurement_process> siger_project_procurement_process { get; set; }
        public DbSet<siger_project_sparepart_order> siger_project_sparepart_order { get; set; }
        public DbSet<siger_project_sparepart_order_detail> siger_project_sparepart_order_detail { get; set; }

        public DbSet<siger_project_machine_attribution> siger_project_machine_attribution { get; set; }

        public DbSet<siger_project_sparepart_audit> siger_project_sparepart_audit { get; set; }

        public DbSet<siger_project_sparepart_audit_detail> siger_project_sparepart_audit_detail { get; set; }

        public DbSet<siger_andon_station_config> siger_andon_station_config { get; set; }

        public DbSet<siger_project_sparepart_code> siger_project_sparepart_code { get; set; }
        public DbSet<SigerProjectEmailConfig> siger_project_email_config { get; set; }
        public DbSet<siger_project_product> siger_project_product { get; set; }

        public DbSet<siger_project_repair_edit_record> siger_project_repair_edit_record { get; set; }
        public DbSet<siger_project_plan_report_tolerance> siger_project_plan_report_tolerance { get; set; }

        public DbSet<siger_project_sparepart_order_approval> siger_project_sparepart_order_approval { get; set; }
        public DbSet<siger_andon_plan> siger_andon_plan { get; set; }
        public DbSet<siger_project_auto_calculation_data_ttlEx> siger_project_auto_calculation_data_hour_ttl { get; set; }//dashboard 汇总oee小时
        public DbSet<siger_project_level> siger_project_level { get; set; }
        public DbSet<siger_project_working_calendar> siger_project_working_calendar { get; set; }
        public DbSet<ProjectOutsourcedMaintenanceEntity> ProjectOutsourcedMaintenanceEntities { get; set; }

        public DbSet<siger_project_working_relation_user> siger_project_working_relation_user { get; set; }
        public DbSet<siger_project_working_relation_machine> siger_project_working_relation_machine { get; set; }
    }
}