﻿using System.Collections.Generic;
using Siger.Middlelayer.Repository.Data.Tpm;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.TpmRepository.Entities;
using Siger.Middlelayer.TpmRepository.Request;
using Siger.Middlelayer.TpmRepository.Response;

namespace Siger.Middlelayer.TpmRepository.Repositories.Interface
{
    public interface IPlanTimeRepository : ITpmRepositoryBase<siger_project_plan_time>
    {
        IPagedCollectionResult<GetListPlanStatus> GetPagedlistPlanstatus(int mode, IEnumerable<int> machineIds, int projectId, int page, int pagesize);

        IEnumerable<GetListPlanStatus> GetListPlanstatusInfo(int mode, int machineid, int information, int projectid);

        IEnumerable<GetListPlanStatus> GetPlanInformation(int mode, int machineid, int nowtime, int endtime, int projectid);

        IEnumerable<ResponseGetPlanForm> GetPlanFormTotal(IEnumerable<int> machineIds, int mode, int starttime, int projectid, int userid);

        GetListPlanStatus GetOnePlanTime(int ptimeid, int projectid);

        IEnumerable<GetListPlanStatus> GetPlanTimeItem(int information, int nowtime, int planid, int projectid);

        IPagedCollectionResult<GetListThirtyPlanItem> GetPagedlistthirdPlanItem(listthirdPlanItem baseModel, IEnumerable<int> machineIds, int startTime, int endTime, int projectId, int page, int pagesize, int searchType);

        /// <summary>
        /// 兼容被禁用的已执行记录
        /// </summary>
        /// <param name="mode"></param>
        /// <param name="start_time"></param>
        /// <param name="end_time"></param>
        /// <param name="machineIds"></param>
        /// <param name="projectid"></param>
        /// <returns></returns>
        IEnumerable<GetSeachPlanDay> SearchPlanDay(int mode, int start_time, int end_time, IEnumerable<int> machineIds, int projectid);

        IEnumerable<GetListPlanStatus> GetPlanInformationByMachineIds(int mode, IEnumerable<int> machineIds,
            int nowtime, int endtime, int projectid);
        IEnumerable<GetListPlanStatus> GetPlanInfoByTime(int start, int end, int projectid);
        IPagedCollectionResult<ResponsePlanMachineChanged> GetCalendarChanged(IEnumerable<int> machineIds, int start, int end, int pid, int page, int pagesize);

        IEnumerable<GetListThirtyPlanItem> GetPlanItems(IEnumerable<int> machineIds, int startTime, int endTime, int projectId);

        IEnumerable<GetListThirtyPlanItem> GetDayPlanItem(int startTime, int endTime, int projectId);
    }
}
