﻿using System.Collections.Generic;
using Siger.Middlelayer.Repository.Data;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Repository.Response;
using Siger.Middlelayer.TpmRepository.Entities;
using Siger.Middlelayer.Utility.ImportEntities;

namespace Siger.Middlelayer.TpmRepository.Repositories.Interface
{
    public interface ISparepartTypeRepository : ITpmRepositoryBase<siger_project_sparepart_type>
    {
        IPagedCollectionResult<ResponseGetSparepartType> GetPagedList(int id, string title, int projectid, int page,
            int pagesize, bool paged = true);

        IEnumerable<SparepartTypeTree> GetLevelSparepartTypes(int projectid);

        IEnumerable<siger_project_sparepart_type> GetSonSparepartTypes(int parentId, int projectid);

        CommonImportResult ImportSparepartType(IEnumerable<SparepartTypeList> types, int projectId);
    }
}
