﻿using System.Collections.Generic;

namespace Siger.Middlelayer.TpmRepository.Response
{
    public class ResponseGetMachineRepair
    {
        public int status { get; set; }

        public string name { get; set; }

        public int count { get; set; }
    }

    public class ResponseGetStatusRepair
    {
        public int status { get; set; }

        public string name { get; set; }

        public int count { get; set; }

        public List<StatusRepairModel> repairlist { get; set; }
    }

    public class StatusRepairModel
    {
        public int machineid { get; set; }

        public List<string> location { get; set; }
        //public string location { get; set; }

        /// <summary>
        /// 报修时间
        /// </summary>
        public string createtime { get; set; }

        /// <summary>
        /// 故障类型
        /// </summary>
        public string faultlist { get; set; }

        /// <summary>
        /// 失效模式
        /// </summary>
        public string faultcontent { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        public string repairremark { get; set; }

        /// <summary>
        /// 1=> 报修 2=>接单 3=>签到 4=>完成维修 5=>复线成功 复线失败改为3 6=>提交维修反馈 0=>删除
        /// </summary>
        public int status { get; set; }

        /// <summary>
        /// 工单号(用于工单详情页面传值)
        /// </summary>
        public int repairid { get; set; }

        /// <summary>
        /// 停线时间 0为未停线
        /// </summary>
        public int offlinetime { get; set; }

        /// <summary>
        /// 0=>不接收消息 1=>接受消息
        /// </summary>
        public int mutestatus { get; set; }

        /// <summary>
        /// 0=>不显示蓝点 1=>显示蓝点
        /// </summary>
        public int markself { get; set; }

        /// <summary>
        /// >1 异常上报
        /// </summary>
        public int report_level { get; set; }

        /// <summary>
        /// 工单号
        /// </summary>
        public string work_order { get; set; }
    }
}
