using System;
using System.Collections.Generic;
using Siger.Middlelayer.Common.ModuleEnum;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Repository.Response;
using Siger.Middlelayer.WmsRepository.Entities;
using Siger.Middlelayer.WmsRepository.Request;
using Siger.Middlelayer.WmsRepository.Response;

namespace Siger.Middlelayer.WmsRepository.Repositories.Interface
{
    public interface Isiger_wms_stock_access_orderRepository: IWMSRepositoryBase<siger_wms_stock_access_order>
    {
        IEnumerable<ResponseWaveHousing> GetWaveHousingBills(int pid,WaveHouseType type, WaveHousingState state, int page, int pageSize,out int totalCount);
        IEnumerable<ResponseBill> GeList( int pid,WaveHouseType bill, WaveHousingType waveHouseType, int waveHouseID, WaveHousingState state, string billCode, string originBillCode, DateTime start, DateTime end, out int totalCount, int page = 1, int pageSize = 10);
        IEnumerable<ResponseDepartment> GetDepartmentList( int pid);
        ResponseInventoryInfo GetInventoryInfo(string pn, int pid,int storageid, int businessid);
        void AddBill(int pid, WaveHouseType billType, string billCode, WaveHousingType wavehousingtype, int businessid, int waveHouseID, string rowBillID, List<Inventory> inventories,int PID,int UID, int picker, int departid);
        void CheckInventory(IEnumerable<int> ids, int pid);
        string getDepartmentName(int contactid, int projectId);
        IEnumerable<ResponseIdName> GetBillCodes(WaveHouseType type, int projectId,int storageid);
        void UpdateBill(int billID, List<Inventory> inventories, int projectId, int userId, int picker);

        void AddBillForChangling(int pid, WaveHouseType billType, string billCode, WaveHousingType wavehousingtype,
            int businessid, string waveHouseID, string rowBillID, List<InventoryForChangling> inventories, int PID,
            int UID, int picker);
        void AddBill(int pid, int userid, RequestAddBill req);
    }
}
