﻿using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using Siger.Middlelayer.Common.ModuleEnum;

namespace Siger.Middlelayer.WmsRepository.Request
{
    public class RequestAddBill
    {
        [Required(ErrorMessage = "BillIDNotNull")]
        public string billID { get; set; }
        public string rowBillID { get; set; }
        /// <summary>
        /// 类型:出库、入库
        /// </summary>
        [Required(ErrorMessage = "WaveHouseTypeNotNull")]
        public WaveHouseType billType { get; set; }
        
        [Required(ErrorMessage = "WaveHouseTypeNotNull")]
        public WaveHousingType wavehousingtype { get; set; }
        /// <summary>
        /// 供应商或部门id
        /// </summary>
        [Required(ErrorMessage = "BusinessIDNotNull")]
        public int businessid { get; set; }
        /// <summary>
        /// 仓库
        /// </summary>
        [Required(ErrorMessage = "WaveHouseIDNotNull")]
        public int waveHouseID { get; set; }

        [Required(ErrorMessage = "InventoryNotNull")]
        public List<Inventory> inventories { get; set; }

        public string picker { get; set; }

        /// <summary>
        /// 部门
        /// </summary>
        public int departid { get; set; }
    }
    public class Inventory
    {
        public int InventoryID { get; set; }
        public int Count { get; set; }
        public int businessID { get; set; }
        public int storage_location_id { get; set; }
    }

    public class InventoryForChangling
    {
        public string InventoryID { get; set; }
        public int Count { get; set; }
        public string businessID { get; set; }
    }
}
